/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block.custom.properties;

import java.math.BigInteger;

public class BlockPropertyUtils {
    public static int bitLength(byte data) {
        if (data < 0) {
            return 32;
        }
        if (data == 0) {
            return 1;
        }
        int bits = 0;
        while (data != 0) {
            data = (byte)(data >>> 1);
            ++bits;
        }
        return bits;
    }

    public static int bitLength(int data) {
        if (data < 0) {
            return 32;
        }
        if (data == 0) {
            return 1;
        }
        int bits = 0;
        while (data != 0) {
            data >>>= 1;
            ++bits;
        }
        return bits;
    }

    public static int bitLength(long data) {
        if (data < 0L) {
            return 64;
        }
        if (data == 0L) {
            return 1;
        }
        int bits = 0;
        while (data != 0L) {
            data >>>= 1;
            ++bits;
        }
        return bits;
    }

    public static int bitLength(BigInteger data) {
        if (data.compareTo(BigInteger.ZERO) < 0) {
            throw new UnsupportedOperationException("Negative BigIntegers are not supported (nearly infinite bits)");
        }
        return data.bitLength();
    }
}

