/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block.custom.properties;

import cn.nukkit.block.custom.properties.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.block.custom.properties.exception.InvalidBlockPropertyValueException;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;

public abstract class BlockProperty<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -2594821043880025191L;
    private final String name;
    private final boolean exportedToItem;
    private final String persistenceName;
    private final int bitSize;

    public BlockProperty(String name, boolean exportedToItem, String persistenceName, int bitSize) {
        Preconditions.checkArgument(bitSize > 0, "Bit size (%s) must be positive", bitSize);
        this.name = name;
        this.exportedToItem = exportedToItem;
        this.persistenceName = persistenceName;
        this.bitSize = bitSize;
    }

    public abstract int getMetaForValue(T var1);

    public abstract T getValueForMeta(int var1);

    public abstract int getIntValueForMeta(int var1);

    public abstract Serializable getPersistenceValueForMeta(int var1);

    public abstract int getMetaForPersistenceValue(String var1);

    public abstract Class<T> getValueClass();

    public abstract boolean isDefaultValue(T var1);

    public abstract T getDefaultValue();

    public abstract BlockProperty<T> exportingToItems(boolean var1);

    public int setValue(int currentMeta, int bitOffset, T newValue) {
        int mask = this.computeValueMask(bitOffset);
        try {
            int value = this.getMetaForValue(newValue) << bitOffset;
            if ((value & ~mask) != 0) {
                throw new IllegalStateException("Attempted to set a value which overflows the size of " + this.bitSize + " bits. Current:" + currentMeta + ", offset:" + bitOffset + ", meta:" + value + ", value:" + newValue);
            }
            return currentMeta & ~mask | value & mask;
        }
        catch (Exception e) {
            Serializable oldValue = null;
            InvalidBlockPropertyMetaException suppressed = null;
            try {
                oldValue = (Serializable)this.getValue(currentMeta, bitOffset);
            }
            catch (Exception e2) {
                suppressed = new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & mask), e2);
            }
            InvalidBlockPropertyValueException toThrow = new InvalidBlockPropertyValueException((BlockProperty<?>)this, oldValue, (Serializable)newValue, e);
            if (suppressed != null) {
                toThrow.addSuppressed(suppressed);
            }
            throw toThrow;
        }
    }

    public long setValue(long currentBigMeta, int bitOffset, T newValue) {
        long mask = this.computeBigValueMask(bitOffset);
        try {
            long value = this.getMetaForValue(newValue) << bitOffset;
            if ((value & (mask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                throw new IllegalStateException("Attempted to set a value which overflows the size of " + this.bitSize + " bits. Current:" + currentBigMeta + ", offset:" + bitOffset + ", meta:" + value + ", value:" + newValue);
            }
            return currentBigMeta & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value & mask;
        }
        catch (Exception e) {
            Serializable oldValue = null;
            InvalidBlockPropertyMetaException suppressed = null;
            try {
                oldValue = (Serializable)this.getValue(currentBigMeta, bitOffset);
            }
            catch (Exception e2) {
                suppressed = new InvalidBlockPropertyMetaException(this, (Number)currentBigMeta, (Number)(currentBigMeta & mask), e2);
            }
            InvalidBlockPropertyValueException toThrow = new InvalidBlockPropertyValueException((BlockProperty<?>)this, oldValue, (Serializable)newValue, e);
            if (suppressed != null) {
                toThrow.addSuppressed(suppressed);
            }
            throw toThrow;
        }
    }

    public BigInteger setValue(BigInteger currentHugeMeta, int bitOffset, T newValue) {
        BigInteger mask = this.computeHugeValueMask(bitOffset);
        try {
            BigInteger value = BigInteger.valueOf(this.getMetaForValue(newValue)).shiftLeft(bitOffset);
            if (!value.andNot(mask).equals(BigInteger.ZERO)) {
                throw new IllegalStateException("Attempted to set a value which overflows the size of " + this.bitSize + " bits. Current:" + currentHugeMeta + ", offset:" + bitOffset + ", meta:" + value + ", value:" + newValue);
            }
            return currentHugeMeta.andNot(mask).or(value.and(mask));
        }
        catch (Exception e) {
            Serializable oldValue = null;
            InvalidBlockPropertyMetaException suppressed = null;
            try {
                oldValue = (Serializable)this.getValue(currentHugeMeta, bitOffset);
            }
            catch (Exception e2) {
                suppressed = new InvalidBlockPropertyMetaException(this, (Number)currentHugeMeta, (Number)currentHugeMeta.and(mask), e2);
            }
            InvalidBlockPropertyValueException toThrow = new InvalidBlockPropertyValueException((BlockProperty<?>)this, oldValue, (Serializable)newValue, e);
            if (suppressed != null) {
                toThrow.addSuppressed(suppressed);
            }
            throw toThrow;
        }
    }

    public T getValue(int currentMeta, int bitOffset) {
        int meta = this.getMetaFromInt(currentMeta, bitOffset);
        try {
            return this.getValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeValueMask(bitOffset)), e);
        }
    }

    public T getValue(long currentBigMeta, int bitOffset) {
        int meta = this.getMetaFromLong(currentBigMeta, bitOffset);
        try {
            return this.getValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentBigMeta, (Number)(currentBigMeta & this.computeBigValueMask(bitOffset)), e);
        }
    }

    public T getValue(BigInteger currentHugeMeta, int bitOffset) {
        int meta = this.getMetaFromBigInt(currentHugeMeta, bitOffset);
        try {
            return this.getValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentHugeMeta, (Number)currentHugeMeta.and(this.computeHugeValueMask(bitOffset)), e);
        }
    }

    public int getIntValue(int currentMeta, int bitOffset) {
        int meta = this.getMetaFromInt(currentMeta, bitOffset);
        try {
            return this.getIntValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeValueMask(bitOffset)), e);
        }
    }

    public int getIntValue(long currentMeta, int bitOffset) {
        int meta = this.getMetaFromLong(currentMeta, bitOffset);
        try {
            return this.getIntValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeBigValueMask(bitOffset)), e);
        }
    }

    public int getIntValue(BigInteger currentMeta, int bitOffset) {
        int meta = this.getMetaFromBigInt(currentMeta, bitOffset);
        try {
            return this.getIntValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)currentMeta.and(this.computeHugeValueMask(bitOffset)), e);
        }
    }

    public Serializable getPersistenceValue(int currentMeta, int bitOffset) {
        int meta = this.getMetaFromInt(currentMeta, bitOffset);
        try {
            return this.getPersistenceValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeValueMask(bitOffset)), e);
        }
    }

    public Serializable getPersistenceValue(long currentMeta, int bitOffset) {
        int meta = this.getMetaFromLong(currentMeta, bitOffset);
        try {
            return this.getPersistenceValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeBigValueMask(bitOffset)), e);
        }
    }

    public Serializable getPersistenceValue(BigInteger currentMeta, int bitOffset) {
        int meta = this.getMetaFromBigInt(currentMeta, bitOffset);
        try {
            return this.getPersistenceValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)currentMeta.and(this.computeHugeValueMask(bitOffset)), e);
        }
    }

    private int computeRightMask(int bitOffset) {
        return bitOffset == 0 ? 0 : -1 >>> 32 - bitOffset;
    }

    private long computeBigRightMask(int bitOffset) {
        return (long)bitOffset == 0L ? 0L : -1L >>> 64 - bitOffset;
    }

    private BigInteger computeHugeRightMask(int bitOffset) {
        return BigInteger.ONE.shiftLeft(bitOffset).subtract(BigInteger.ONE);
    }

    private int computeValueMask(int bitOffset) {
        Preconditions.checkArgument(bitOffset >= 0, "Bit offset can not be negative. Got %s", bitOffset);
        int maskBits = this.bitSize + bitOffset;
        Preconditions.checkArgument(0 < maskBits && maskBits <= 32, "The bit offset %s plus the bit size %s causes memory overflow (32 bits)", bitOffset, this.bitSize);
        int rightMask = this.computeRightMask(bitOffset);
        int leftMask = -1 << maskBits;
        return ~rightMask & ~leftMask;
    }

    private long computeBigValueMask(int bitOffset) {
        Preconditions.checkArgument(bitOffset >= 0, "Bit offset can not be negative. Got %s", bitOffset);
        int maskBits = this.bitSize + bitOffset;
        Preconditions.checkArgument(0 < maskBits && maskBits <= 64, "The bit offset %s plus the bit size %s causes memory overflow (64 bits)", bitOffset, this.bitSize);
        long rightMask = this.computeBigRightMask(bitOffset);
        long leftMask = -1L << maskBits;
        return (rightMask ^ 0xFFFFFFFFFFFFFFFFL) & (leftMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private BigInteger computeHugeValueMask(int bitOffset) {
        Preconditions.checkArgument(bitOffset >= 0, "Bit offset can not be negative. Got %s", bitOffset);
        int maskBits = this.bitSize + bitOffset;
        Preconditions.checkArgument(0 < maskBits, "The bit offset %s plus the bit size %s causes memory overflow (huge)", bitOffset, this.bitSize);
        BigInteger rightMask = this.computeHugeRightMask(bitOffset);
        BigInteger leftMask = BigInteger.valueOf(-1L).shiftLeft(maskBits);
        return rightMask.not().andNot(leftMask);
    }

    public final int getMetaFromInt(int currentMeta, int bitOffset) {
        return (currentMeta & this.computeValueMask(bitOffset)) >>> bitOffset;
    }

    public final int getMetaFromLong(long currentMeta, int bitOffset) {
        return (int)((currentMeta & this.computeBigValueMask(bitOffset)) >>> bitOffset);
    }

    public final int getMetaFromBigInt(BigInteger currentMeta, int bitOffset) {
        return currentMeta.and(this.computeHugeValueMask(bitOffset)).shiftRight(bitOffset).intValue();
    }

    protected void validateDirectly(T value) {
    }

    protected abstract void validateMetaDirectly(int var1);

    public final void validateMeta(int meta, int offset) {
        int propMeta = this.getMetaFromInt(meta, offset);
        try {
            this.validateMetaDirectly(propMeta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)(meta & this.computeValueMask(offset)), e);
        }
    }

    public final void validateMeta(long meta, int offset) {
        int propMeta = this.getMetaFromLong(meta, offset);
        try {
            this.validateMetaDirectly(propMeta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)(meta & this.computeBigValueMask(offset)), e);
        }
    }

    public final void validateMeta(BigInteger meta, int offset) {
        int propMeta = this.getMetaFromBigInt(meta, offset);
        try {
            this.validateMetaDirectly(propMeta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta.and(this.computeHugeRightMask(offset)), e);
        }
    }

    public boolean isDefaultIntValue(int value) {
        return value == this.getDefaultIntValue();
    }

    public boolean isDefaultBooleanValue(boolean value) {
        return value == this.getDefaultBooleanValue();
    }

    public int getDefaultIntValue() {
        return 0;
    }

    public boolean getDefaultBooleanValue() {
        return false;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistenceName() {
        return this.persistenceName;
    }

    public boolean isExportedToItem() {
        return this.exportedToItem;
    }

    public abstract BlockProperty<T> copy();

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", bitSize=" + this.bitSize + ", exportedToItem=" + this.exportedToItem + ", persistenceName='" + this.persistenceName + '\'' + '}';
    }
}

