/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block.custom.container;

import cn.nukkit.block.custom.container.BlockContainer;
import cn.nukkit.block.custom.properties.BlockProperties;
import cn.nukkit.block.custom.properties.BlockProperty;
import java.io.Serializable;

public interface BlockStorageContainer
extends BlockContainer {
    public int getStorage();

    public void setStorage(int var1);

    public BlockProperties getBlockProperties();

    @Override
    default public int getNukkitDamage() {
        return this.getStorage() & 0x3F;
    }

    default public void setBooleanValue(BlockProperty<Boolean> property, boolean value) {
        this.setBooleanValue(property.getName(), value);
    }

    default public void setBooleanValue(String propertyName, boolean value) {
        this.setStorage(this.getBlockProperties().setBooleanValue(this.getStorage(), propertyName, value));
    }

    default public void setPropertyValue(String propertyName, Serializable value) {
        this.setStorage(this.getBlockProperties().setValue(this.getStorage(), propertyName, value));
    }

    default public <T extends Serializable> void setPropertyValue(BlockProperty<T> property, T value) {
        this.setPropertyValue(property.getName(), value);
    }

    default public void setIntValue(String propertyName, int value) {
        this.setStorage(this.getBlockProperties().setIntValue(this.getStorage(), propertyName, value));
    }

    default public Serializable getPropertyValue(String propertyName) {
        return this.getBlockProperties().getValue(this.getStorage(), propertyName);
    }

    default public <V extends Serializable> V getPropertyValue(BlockProperty<V> property) {
        return (V)((Serializable)this.getCheckedPropertyValue(property.getName(), property.getValueClass()));
    }

    default public <T> T getCheckedPropertyValue(String propertyName, Class<T> tClass) {
        return tClass.cast(this.getPropertyValue(propertyName));
    }

    default public int getIntValue(String propertyName) {
        return this.getBlockProperties().getIntValue(this.getStorage(), propertyName);
    }

    default public boolean getBooleanValue(BlockProperty<Boolean> property) {
        return this.getBooleanValue(property.getName());
    }

    default public boolean getBooleanValue(String propertyName) {
        return this.getBlockProperties().getBooleanValue(this.getStorage(), propertyName);
    }

    default public void setStorageFromItem(int itemMeta) {
        BlockProperties properties = this.getBlockProperties();
        BlockProperties itemProperties = properties.getItemBlockProperties();
        if (itemProperties.equals(properties)) {
            this.setStorage(itemMeta);
            return;
        }
        int damage = 0;
        for (String propertyName : itemProperties.getItemPropertyNames()) {
            damage = properties.setValue(damage, propertyName, itemProperties.getValue(itemMeta, propertyName));
        }
        this.setStorage(damage);
    }
}

