/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.WaxOffParticle;
import cn.nukkit.level.particle.WaxOnParticle;

public interface Waxable {
    public Location getLocation();

    default public boolean onActivate(Item item, Player player) {
        Position location;
        boolean waxed = this.isWaxed();
        if (!(item.getId() == 736 && !waxed || item.isAxe() && waxed)) {
            return false;
        }
        boolean bl = waxed = !waxed;
        if (!this.setWaxed(waxed)) {
            return false;
        }
        Position position = location = this instanceof Block ? (Position)((Object)this) : this.getLocation();
        if (player == null || !player.isCreative()) {
            if (waxed) {
                --item.count;
            } else {
                item.useOn(this instanceof Block ? (Block)((Object)this) : location.getLevelBlock());
            }
        }
        location.getLevel().addParticle(waxed ? new WaxOnParticle(location) : new WaxOffParticle(location));
        return true;
    }

    public boolean isWaxed();

    public boolean setWaxed(boolean var1);
}

