/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.Waxable;
import cn.nukkit.block.properties.OxidizationLevel;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.ScrapeParticle;
import java.util.concurrent.ThreadLocalRandom;

public interface Oxidizable {
    public Location getLocation();

    default public int onUpdate(int type) {
        if (type != 2) {
            return 0;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (!(random.nextFloat() < 0.05688889f)) {
            return 0;
        }
        int oxiLvl = this.getOxidizationLevel().ordinal();
        if (oxiLvl == OxidizationLevel.OXIDIZED.ordinal()) {
            return 0;
        }
        if (this instanceof Waxable && ((Waxable)((Object)this)).isWaxed()) {
            return 0;
        }
        Block block = this instanceof Block ? (Block)((Object)this) : this.getLocation().getLevelBlock();
        Location mutableLocation = block.getLocation();
        int odds = 0;
        int cons = 0;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    Block relative;
                    if (x == 0 && y == 0 && z == 0) continue;
                    mutableLocation.setComponents(block.x + (double)x, block.y + (double)y, block.z + (double)z);
                    if (block.distanceSquared(mutableLocation) > 4.0 || !((relative = mutableLocation.getLevelBlock()) instanceof Oxidizable)) continue;
                    int relOxiLvl = ((Oxidizable)((Object)relative)).getOxidizationLevel().ordinal();
                    if (relOxiLvl < oxiLvl) {
                        return type;
                    }
                    if (relOxiLvl > oxiLvl) {
                        ++cons;
                        continue;
                    }
                    ++odds;
                }
            }
        }
        float chance = (float)(cons + 1) / (float)(cons + odds + 1);
        float multiplier = oxiLvl == 0 ? 0.75f : 1.0f;
        chance = chance * chance * multiplier;
        if (random.nextFloat() < chance) {
            Block nextBlock = this.getStateWithOxidizationLevel(OxidizationLevel.values()[oxiLvl + 1]);
            BlockFadeEvent event = new BlockFadeEvent(block, nextBlock);
            block.getLevel().getServer().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                block.getLevel().setBlock(block, event.getNewState());
            }
        }
        return type;
    }

    default public boolean onActivate(Item item, Player player) {
        Position location;
        if (!item.isAxe()) {
            return false;
        }
        OxidizationLevel oxidizationLevel = this.getOxidizationLevel();
        if (OxidizationLevel.UNAFFECTED.equals((Object)oxidizationLevel)) {
            return false;
        }
        oxidizationLevel = OxidizationLevel.values()[oxidizationLevel.ordinal() - 1];
        if (!this.setOxidizationLevel(oxidizationLevel)) {
            return false;
        }
        Position position = location = this instanceof Block ? (Position)((Object)this) : this.getLocation();
        if (player == null || !player.isCreative()) {
            item.useOn(this instanceof Block ? (Block)((Object)this) : location.getLevelBlock());
        }
        location.getLevel().addParticle(new ScrapeParticle(location));
        return true;
    }

    public OxidizationLevel getOxidizationLevel();

    public boolean setOxidizationLevel(OxidizationLevel var1);

    public Block getStateWithOxidizationLevel(OxidizationLevel var1);
}

