/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockWood;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.utils.BlockColor;

public class BlockWood2
extends BlockWood {
    public static final int ACACIA = 0;
    public static final int DARK_OAK = 1;
    private static final String[] NAMES = new String[]{"Acacia Wood", "Dark Oak Wood", ""};

    public BlockWood2() {
        this(0);
    }

    public BlockWood2(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 162;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() > 2 ? 0 : this.getDamage()];
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            case 0: {
                return BlockColor.ORANGE_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.BROWN_BLOCK_COLOR;
            }
        }
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public Item toItem() {
        if (this.getDamage() > 11) {
            int variant = this.getDamage() & 7;
            return new ItemBlock(Block.get(467, variant), variant);
        }
        return new ItemBlock((Block)this, this.getDamage() & 3);
    }

    @Override
    protected int getStrippedId() {
        int damage = this.getDamage();
        if ((damage & 0xC) == 12) {
            return 467;
        }
        int typeId = damage & 3;
        if (typeId == 0) {
            return 263;
        }
        return 264;
    }

    @Override
    protected int getStrippedDamage() {
        int damage = this.getDamage();
        if ((damage & 0xC) == 12) {
            int typeId = damage & 3;
            if (typeId == 0) {
                return 12;
            }
            return 13;
        }
        return super.getStrippedDamage();
    }
}

