/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockWoodBark;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockWood
extends BlockSolidMeta {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;
    private static final short[] FACES = new short[]{0, 0, 8, 8, 4, 4};
    private static final int[] STRIPPED_IDS = new int[]{265, 260, 261, 262};
    private static final String[] NAMES = new String[]{"Oak Wood", "Spruce Wood", "Birch Wood", "Jungle Wood"};

    public BlockWood() {
        this(0);
    }

    public BlockWood(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 3];
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 10;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(this.getDamage() & 3 | FACES[face.getIndex()]);
        this.getLevel().setBlock(block, this, true, true);
        return true;
    }

    @Override
    public Item toItem() {
        if (this.getDamage() > 11) {
            int variant = this.getDamage() & 3;
            return new ItemBlock(Block.get(467, variant), variant);
        }
        return new ItemBlock((Block)this, this.getDamage() & 3);
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 3) {
            default: {
                return BlockColor.WOOD_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.SPRUCE_BLOCK_COLOR;
            }
            case 2: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 3: 
        }
        return BlockColor.DIRT_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.isAxe() && player != null && (player.isSurvival() || player.isCreative()) && (!(this instanceof BlockWoodBark) || this.getDamage() < 8)) {
            Block strippedBlock = Block.get(this.getStrippedId(), this.getStrippedDamage());
            item.useOn(this);
            this.level.setBlock(this, strippedBlock, true, true);
            return true;
        }
        return false;
    }

    protected int getStrippedId() {
        int damage = this.getDamage();
        if ((damage & 0xC) == 12) {
            return 467;
        }
        return STRIPPED_IDS[damage & 3];
    }

    protected int getStrippedDamage() {
        int damage = this.getDamage();
        if ((damage & 0xC) == 12) {
            return damage & 3 | 8;
        }
        return damage >> 2;
    }
}

