/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.WaterFrostEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockWater
extends BlockLiquid {
    private byte freezing;

    public BlockWater() {
        this(0);
    }

    public BlockWater(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    public String getName() {
        return "Water";
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean ret = this.getLevel().setBlock(this, this, true, false);
        this.getLevel().scheduleUpdate(this, this.tickRate());
        return ret;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WATER_BLOCK_COLOR;
    }

    @Override
    public BlockLiquid getBlock(int meta) {
        return (BlockLiquid)Block.get(8, meta);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        super.onEntityCollide(entity);
        if (entity.fireTicks > 0) {
            entity.extinguish();
        }
    }

    @Override
    public int tickRate() {
        return 5;
    }

    @Override
    public int onUpdate(int type) {
        if (this.freezing != 1 && type == 2 && this.getDamage() == 0) {
            FullChunk chunk = this.getChunk();
            if (this.freezing < 1) {
                this.freezing = (byte)(Biome.getBiome(chunk.getBiomeId((int)this.x & 0xF, (int)this.z & 0xF)).isFreezing() ? 2 : 1);
            }
            if (this.freezing == 2 && ThreadLocalRandom.current().nextInt(10) == 0 && chunk.getBlockLight((int)this.x & 0xF, (int)this.y, (int)this.z & 0xF) < 12 && (double)chunk.getHighestBlockAt((int)this.x & 0xF, (int)this.z & 0xF, false) <= this.y) {
                WaterFrostEvent ev = new WaterFrostEvent(this);
                this.level.getServer().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.level.setBlock(this, Block.get(79), true, true);
                }
            }
            return 2;
        }
        return super.onUpdate(type);
    }

    @Override
    public boolean usesWaterLogging() {
        return this.level == null || !(this.level.getProvider() instanceof Anvil);
    }
}

