/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BlockVinesNether
extends BlockTransparentMeta {
    public BlockVinesNether() {
        this(0);
    }

    public BlockVinesNether(int meta) {
        super(meta);
    }

    public abstract BlockFace getGrowthDirection();

    public abstract int getVineAge();

    public abstract void setVineAge(int var1);

    public abstract int getMaxVineAge();

    public void randomizeVineAge(boolean pseudorandom) {
        if (pseudorandom) {
            this.setVineAge(ThreadLocalRandom.current().nextInt(this.getMaxVineAge()));
            return;
        }
        double chance = 1.0;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int age = 0;
        while (random.nextDouble() < chance) {
            chance *= 0.826;
            ++age;
        }
        this.setVineAge(age);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        Block support = this.getSide(this.getGrowthDirection().getOpposite());
        if (!this.isSupportValid(support)) {
            return false;
        }
        if (support.getId() == this.getId()) {
            this.setVineAge(Math.min(this.getMaxVineAge(), ((BlockVinesNether)support).getVineAge() + 1));
        } else {
            this.randomizeVineAge(true);
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public int onUpdate(int type) {
        switch (type) {
            case 2: {
                int maxVineAge = this.getMaxVineAge();
                if (this.getVineAge() < maxVineAge && ThreadLocalRandom.current().nextInt(10) == 0 && this.findVineAge(true).orElse(maxVineAge) < maxVineAge) {
                    this.grow();
                }
                return 2;
            }
            case 1: {
                if (!this.isSupportValid()) {
                    this.getLevel().useBreakOn(this);
                }
                return 1;
            }
        }
        return 0;
    }

    public boolean grow() {
        Block pos = this.getSide(this.getGrowthDirection());
        if (pos.getId() != 0 || pos.y < (double)this.level.getMinBlockY() || pos.y > (double)this.level.getMaxBlockY()) {
            return false;
        }
        BlockVinesNether growing = this.clone();
        growing.x = pos.x;
        growing.y = pos.y;
        growing.z = pos.z;
        growing.setVineAge(Math.min(this.getVineAge() + 1, this.getMaxVineAge()));
        BlockGrowEvent ev = new BlockGrowEvent(this, growing);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        if (this.level.setBlock(pos, growing)) {
            this.increaseRootAge();
            return true;
        }
        return false;
    }

    public int growMultiple() {
        Block pos;
        BlockFace growthDirection = this.getGrowthDirection();
        int age = this.getVineAge() + 1;
        int maxAge = this.getMaxVineAge();
        BlockVinesNether growing = this.clone();
        growing.randomizeVineAge(false);
        int blocksToGrow = growing.getVineAge();
        int grew = 0;
        for (int distance = 1; distance <= blocksToGrow && (pos = this.getSide(growthDirection, distance)).getId() == 0 && !(pos.y < (double)this.level.getMinBlockY()) && !(pos.y > (double)this.level.getMaxBlockY()); ++distance) {
            growing.setVineAge(Math.min(age++, maxAge));
            growing.x = pos.x;
            growing.y = pos.y;
            growing.z = pos.z;
            BlockGrowEvent ev = new BlockGrowEvent(this, growing.clone());
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled() || !this.level.setBlock(pos, ev.getNewState())) break;
            ++grew;
        }
        if (grew > 0) {
            this.increaseRootAge();
        }
        return grew;
    }

    @Nonnull
    public OptionalInt findVineAge(boolean base) {
        return this.findVineBlock(base).map(vine -> OptionalInt.of(vine.getVineAge())).orElse(OptionalInt.empty());
    }

    @Nonnull
    public Optional<BlockVinesNether> findVineBlock(boolean base) {
        return this.findVine(base).map(Position::getLevelBlock).filter(BlockVinesNether.class::isInstance).map(BlockVinesNether.class::cast);
    }

    @Nonnull
    public Optional<Position> findVine(boolean base) {
        Position next;
        BlockFace supportFace = this.getGrowthDirection();
        if (base) {
            supportFace = supportFace.getOpposite();
        }
        Position result = this.getLocation();
        int id = this.getId();
        int limit = 256;
        while (--limit > 0 && (next = result.getSide(supportFace)).getLevelBlock().getId() == id) {
            result = next;
        }
        return Optional.of(result);
    }

    public Optional<Boolean> increaseRootAge() {
        Block base = this.findVine(true).map(Position::getLevelBlock).orElse(null);
        if (!(base instanceof BlockVinesNether)) {
            return Optional.empty();
        }
        BlockVinesNether baseVine = (BlockVinesNether)base;
        int vineAge = baseVine.getVineAge();
        if (vineAge < baseVine.getMaxVineAge()) {
            baseVine.setVineAge(vineAge + 1);
            if (this.getLevel().setBlock(baseVine, baseVine)) {
                return Optional.of(true);
            }
        }
        return Optional.of(false);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        if (item.getId() != 351 || item.getDamage() != 15) {
            return false;
        }
        this.getLevel().addParticle(new BoneMealParticle(this));
        this.findVineBlock(false).ifPresent(BlockVinesNether::growMultiple);
        if (player != null && !player.isCreative()) {
            --item.count;
        }
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        int enchantmentLevel;
        if (item.isShears() || (enchantmentLevel = item.getEnchantmentLevel(18)) >= 3) {
            return new Item[]{this.toItem()};
        }
        int chance = 3 + enchantmentLevel * 2;
        if (ThreadLocalRandom.current().nextInt(9) < chance) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    protected boolean isSupportValid(@Nonnull Block support) {
        return support.getId() == this.getId() || !support.isTransparent();
    }

    public boolean isSupportValid() {
        return this.isSupportValid(this.getSide(this.getGrowthDirection().getOpposite()));
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.resetFallDistance();
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public boolean canBeClimbed() {
        return true;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public double getMinX() {
        return this.x + 0.25;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.25;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.75;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.75;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.9375;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public BlockVinesNether clone() {
        return (BlockVinesNether)super.clone();
    }
}

