/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockTrapdoor
extends BlockTransparentMeta
implements Faceable {
    public static final int TRAPDOOR_OPEN_BIT = 8;
    public static final int TRAPDOOR_TOP_BIT = 4;
    private static final int[] FACES = new int[]{2, 1, 3, 0};
    private static final AxisAlignedBB[] BOUNDING_BOX_DAMAGE = new AxisAlignedBB[16];

    public BlockTrapdoor() {
        this(0);
    }

    public BlockTrapdoor(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 96;
    }

    @Override
    public String getName() {
        return "Oak Trapdoor";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    private AxisAlignedBB getRelativeBoundingBox() {
        return BOUNDING_BOX_DAMAGE[this.getDamage()];
    }

    @Override
    public double getMinX() {
        return this.x + this.getRelativeBoundingBox().getMinX();
    }

    @Override
    public double getMaxX() {
        return this.x + this.getRelativeBoundingBox().getMaxX();
    }

    @Override
    public double getMinY() {
        return this.y + this.getRelativeBoundingBox().getMinY();
    }

    @Override
    public double getMaxY() {
        return this.y + this.getRelativeBoundingBox().getMaxY();
    }

    @Override
    public double getMinZ() {
        return this.z + this.getRelativeBoundingBox().getMinZ();
    }

    @Override
    public double getMaxZ() {
        return this.z + this.getRelativeBoundingBox().getMaxZ();
    }

    @Override
    public int onUpdate(int type) {
        if (type == 6) {
            boolean powered = this.level.isBlockPowered(this);
            if (!this.isOpen() && powered || this.isOpen() && !powered) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
                this.setDamage(this.getDamage() ^ 8);
                this.level.setBlock(this, this, true);
                if (this.isOpen()) {
                    this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
                } else {
                    this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
                }
                return type;
            }
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean top;
        BlockFace facing;
        int meta = 0;
        if (face.getAxis().isHorizontal() || player == null) {
            facing = face;
            top = fy > 0.5;
        } else {
            facing = player.getDirection().getOpposite();
            top = face != BlockFace.UP;
        }
        meta |= FACES[facing.getHorizontalIndex()];
        if (top) {
            meta |= 4;
        }
        this.setDamage(meta);
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        return this.toggle(player);
    }

    public boolean toggle(Player player) {
        DoorToggleEvent ev = new DoorToggleEvent(this, player);
        this.level.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.setDamage(this.getDamage() ^ 8);
        this.level.setBlock(this, this, true, true);
        if (this.isOpen()) {
            this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
        } else {
            this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    public boolean isOpen() {
        return (this.getDamage() & 8) != 0;
    }

    public boolean isTop() {
        return (this.getDamage() & 4) != 0;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean canPassThrough() {
        return this.isOpen();
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    static {
        for (int damage = 0; damage < 16; ++damage) {
            double f = 0.1875;
            SimpleAxisAlignedBB bb = (damage & 4) > 0 ? new SimpleAxisAlignedBB(0.0, 1.0 - f, 0.0, 1.0, 1.0, 1.0) : new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0 + f, 1.0);
            if ((damage & 8) > 0) {
                if ((damage & 3) == 0) {
                    bb.setBounds(0.0, 0.0, 1.0 - f, 1.0, 1.0, 1.0);
                } else if ((damage & 3) == 1) {
                    bb.setBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.0 + f);
                }
                if ((damage & 3) == 2) {
                    bb.setBounds(1.0 - f, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                if ((damage & 3) == 3) {
                    bb.setBounds(0.0, 0.0, 0.0, 0.0 + f, 1.0, 1.0);
                }
            }
            BlockTrapdoor.BOUNDING_BOX_DAMAGE[damage] = bb;
        }
    }
}

