/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockTorch
extends BlockFlowable
implements Faceable {
    private static final short[] FACES = new short[]{0, 5, 4, 3, 2, 1};
    private static final short[] FACES_2 = new short[]{0, 4, 5, 2, 3, 0, 0};

    public BlockTorch() {
        this(0);
    }

    public BlockTorch(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Torch";
    }

    @Override
    public int getId() {
        return 50;
    }

    @Override
    public int getLightLevel() {
        return 14;
    }

    @Override
    public int onUpdate(int type) {
        int side;
        if (type == 1 && ((side = this.getDamage()) != 0 && !Block.canConnectToFullSolid(this.getSide(BlockFace.fromIndex(FACES_2[side]))) || side == 0 && !this.isSupportValidBelow())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block instanceof BlockWater || block.level.isBlockWaterloggedAt(block.getChunk(), (int)block.x, (int)block.y, (int)block.z)) {
            return false;
        }
        short side = FACES[face.getIndex()];
        if (face != BlockFace.UP) {
            if (Block.canConnectToFullSolid(this.getSide(BlockFace.fromIndex(FACES_2[side])))) {
                this.setDamage(side);
                return this.getLevel().setBlock(this, this, true, true);
            }
            return false;
        }
        if (this.isSupportValidBelow()) {
            this.setDamage(0);
            return this.getLevel().setBlock(this, this, true, true);
        }
        return false;
    }

    private boolean isSupportValidBelow() {
        Block block = this.down();
        if (!block.isTransparent() || block.isNarrowSurface()) {
            return true;
        }
        return Block.canStayOnFullSolid(block);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getBlockFace(this.getDamage() & 7);
    }

    public BlockFace getBlockFace(int meta) {
        switch (meta) {
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.WEST;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.NORTH;
            }
        }
        return BlockFace.UP;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

