/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.block.BlockHarvestEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockSweetBerryBush
extends BlockFlowable {
    public BlockSweetBerryBush() {
        this(0);
    }

    public BlockSweetBerryBush(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Sweet Berry Bush";
    }

    @Override
    public int getId() {
        return 462;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getBurnChance() {
        return 30;
    }

    @Override
    public int getBurnAbility() {
        return 60;
    }

    @Override
    public Item toItem() {
        return Item.get(477);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (this.getDamage() > 0 && !(entity instanceof EntityItem)) {
            entity.resetFallDistance();
            if (!entity.isSneaking() && ThreadLocalRandom.current().nextInt(20) == 0 && entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.CONTACT, 1.0f))) {
                this.level.addLevelSoundEvent(entity, 262);
            }
        }
    }

    @Override
    public boolean hasEntityCollision() {
        return this.getDamage() > 0;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        if (this.getDamage() > 0) {
            return this;
        }
        return null;
    }

    @Override
    public Item[] getDrops(Item item) {
        int age = MathHelper.clamp(this.getDamage(), 0, 3);
        int amount = 1;
        if (age > 1) {
            amount = 1 + ThreadLocalRandom.current().nextInt(2);
            if (age == 3) {
                ++amount;
            }
        }
        return new Item[]{Item.get(477, (Integer)0, amount)};
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        int age = MathHelper.clamp(this.getDamage(), 0, 3);
        if (age < 3 && item.getId() == 351 && item.getDamage() == DyeColor.WHITE.getDyeData()) {
            BlockSweetBerryBush block = (BlockSweetBerryBush)this.clone();
            block.setDamage(block.getDamage() + 1);
            if (block.getDamage() > 3) {
                block.setDamage(3);
            }
            BlockGrowEvent ev = new BlockGrowEvent(this, block);
            this.getLevel().getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            this.getLevel().setBlock(this, ev.getNewState(), false, true);
            this.level.addParticle(new BoneMealParticle(this));
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            return true;
        }
        if (age < 2) {
            return true;
        }
        int amount = 1 + ThreadLocalRandom.current().nextInt(2);
        if (age == 3) {
            ++amount;
        }
        BlockHarvestEvent event = new BlockHarvestEvent(this, Block.get(462, 1), new Item[]{Item.get(477, (Integer)0, amount)});
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.getLevel().setBlock(this, event.getNewState(), true, true);
            Item[] drops = event.getDrops();
            if (drops != null) {
                Position dropPos = this.add(0.5, 0.5, 0.5);
                for (Item drop : drops) {
                    if (drop == null) continue;
                    this.getLevel().dropItem(dropPos, drop);
                }
            }
            this.level.addLevelSoundEvent(this, 263);
        }
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!BlockSweetBerryBush.isSupportValid(this.down())) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 2) {
            BlockGrowEvent event;
            if (this.getDamage() < 3 && ThreadLocalRandom.current().nextInt(5) == 0 && !(event = new BlockGrowEvent(this, Block.get(this.getId(), this.getDamage() + 1))).isCancelled()) {
                this.getLevel().setBlock(this, event.getNewState(), true, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.getId() == 462 || block.getId() != 0) {
            return false;
        }
        if (BlockSweetBerryBush.isSupportValid(this.down())) {
            this.getLevel().setBlock(block, this, true);
            return true;
        }
        return false;
    }

    public static boolean isSupportValid(Block block) {
        switch (block.getId()) {
            case 2: 
            case 3: 
            case 60: 
            case 110: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

