/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockSugarcane
extends BlockFlowable {
    public BlockSugarcane() {
        this(0);
    }

    public BlockSugarcane(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Sugar Cane";
    }

    @Override
    public int getId() {
        return 83;
    }

    @Override
    public Item toItem() {
        return Item.get(338);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            int count = 1;
            for (int i = 1; i <= 2; ++i) {
                int id = this.level.getBlockIdAt(this.getFloorX(), this.getFloorY() - i, this.getFloorZ());
                if (id != 83) continue;
                ++count;
            }
            if (count < 3) {
                boolean success = false;
                int toGrow = 3 - count;
                for (int i = 1; i <= toGrow; ++i) {
                    Block block = this.up(i);
                    if (block.getId() == 0) {
                        BlockGrowEvent ev = new BlockGrowEvent(block, Block.get(83));
                        Server.getInstance().getPluginManager().callEvent(ev);
                        if (ev.isCancelled()) continue;
                        this.getLevel().setBlock(block, ev.getNewState(), true);
                        success = true;
                        continue;
                    }
                    if (block.getId() != 83) break;
                }
                if (success) {
                    if (player != null && !player.isCreative()) {
                        --item.count;
                    }
                    this.level.addParticle(new BoneMealParticle(this));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block down = this.down();
            if (down.isTransparent() && down.getId() != 83) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 2 && this.down().getId() != 83) {
            if (this.getDamage() == 15) {
                for (int y = 1; y < 3; ++y) {
                    Block b = this.getLevel().getBlock((int)this.x, (int)this.y + y, (int)this.z);
                    if (b.getId() != 0) continue;
                    BlockGrowEvent ev = new BlockGrowEvent(b, Block.get(83));
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (ev.isCancelled()) break;
                    this.getLevel().setBlock(b, ev.getNewState(), false);
                    break;
                }
                this.setDamage(0);
            } else {
                this.setDamage(this.getDamage() + 1);
            }
            this.level.setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, true, false);
            return 2;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block.getId() != 0) {
            return false;
        }
        Block down = this.down();
        int id = down.getId();
        if (id == 83) {
            this.getLevel().setBlock(block, Block.get(83), true);
            return true;
        }
        if (id == 2 || id == 3 || id == 12 || id == 243 || id == 110) {
            Block block0 = down.north();
            Block block1 = down.south();
            Block block2 = down.west();
            Block block3 = down.east();
            if (block0 instanceof BlockWater || block1 instanceof BlockWater || block2 instanceof BlockWater || block3 instanceof BlockWater || block0 instanceof BlockIceFrosted || block1 instanceof BlockIceFrosted || block2 instanceof BlockIceFrosted || block3 instanceof BlockIceFrosted) {
                this.getLevel().setBlock(block, Block.get(83), true);
                return true;
            }
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

