/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCrops;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.Utils;

public class BlockStemMelon
extends BlockCrops {
    public BlockStemMelon() {
        this(0);
    }

    public BlockStemMelon(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 105;
    }

    @Override
    public String getName() {
        return "Melon Stem";
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.down().getId() != 60) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 2) {
            if (Utils.rand()) {
                Block d;
                if (this.getDamage() < 7) {
                    Block block = this.clone();
                    block.setDamage(block.getDamage() + 1);
                    BlockGrowEvent ev = new BlockGrowEvent(this, block);
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().setBlock(this, ev.getNewState(), true);
                    }
                    return 2;
                }
                for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
                    Block b = this.getSide(face);
                    if (b.getId() != 103) continue;
                    return 2;
                }
                Block side = this.getSide(BlockFace.Plane.HORIZONTAL.random());
                if (side.getId() == 0 && ((d = side.down()).getId() == 60 || d.getId() == 2 || d.getId() == 3)) {
                    BlockGrowEvent ev = new BlockGrowEvent(side, Block.get(103));
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().setBlock(side, ev.getNewState(), true);
                    }
                }
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return Item.get(362);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.getDamage() < 4) {
            return new Item[0];
        }
        return new Item[]{Item.get(362, (Integer)0, Utils.rand(0, 48) >> 4)};
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

