/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockStairsCopperBase;
import cn.nukkit.block.properties.OxidizationLevel;

public class BlockStairsCopperCut
extends BlockStairsCopperBase {
    public BlockStairsCopperCut() {
        this(0);
    }

    public BlockStairsCopperCut(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        OxidizationLevel oxidizationLevel;
        String name = "";
        if (this.isWaxed()) {
            name = name + "Waxed ";
        }
        if ((oxidizationLevel = this.getOxidizationLevel()) != OxidizationLevel.UNAFFECTED) {
            String oxidationName = oxidizationLevel.name();
            name = name + oxidationName.charAt(0) + oxidationName.substring(1).toLowerCase();
        }
        return name + " Cut Copper Stairs";
    }

    @Override
    public int getId() {
        return 609;
    }

    @Override
    protected int getCopperId(boolean waxed, OxidizationLevel oxidizationLevel) {
        if (oxidizationLevel == null) {
            return this.getId();
        }
        switch (oxidizationLevel) {
            case UNAFFECTED: {
                return waxed ? 613 : 609;
            }
            case EXPOSED: {
                return waxed ? 614 : 610;
            }
            case WEATHERED: {
                return waxed ? 615 : 611;
            }
            case OXIDIZED: {
                return waxed ? 703 : 612;
            }
        }
        return this.getId();
    }

    @Override
    public OxidizationLevel getOxidizationLevel() {
        return OxidizationLevel.UNAFFECTED;
    }
}

