/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.utils.Faceable;

public abstract class BlockStairs
extends BlockSolidMeta
implements Faceable {
    private static final short[] FACES = new short[]{2, 1, 3, 0};

    protected BlockStairs(int meta) {
        super(meta);
    }

    @Override
    public double getMinY() {
        return this.y + (double)(this.getDamage() & 4) > 0.0 ? 0.5 : 0.0;
    }

    @Override
    public double getMaxY() {
        return this.y + (double)(this.getDamage() & 4) > 0.0 ? 1.0 : 0.5;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(FACES[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        if (fy > 0.5 && face != BlockFace.UP || face == BlockFace.DOWN) {
            this.setDamage(this.getDamage() | 4);
        }
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe()) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public boolean collidesWithBB(AxisAlignedBB bb) {
        int damage = this.getDamage();
        int side = damage & 3;
        double f = 0.0;
        double f1 = 0.5;
        double f2 = 0.5;
        double f3 = 1.0;
        if ((damage & 4) > 0) {
            f = 0.5;
            f1 = 1.0;
            f2 = 0.0;
            f3 = 0.5;
        }
        if (bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f, this.z, this.x + 1.0, this.y + f1, this.z + 1.0))) {
            return true;
        }
        if (side == 0) {
            return bb.intersectsWith(new SimpleAxisAlignedBB(this.x + 0.5, this.y + f2, this.z, this.x + 1.0, this.y + f3, this.z + 1.0));
        }
        if (side == 1) {
            return bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f2, this.z, this.x + 0.5, this.y + f3, this.z + 1.0));
        }
        if (side == 2) {
            return bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f2, this.z + 0.5, this.x + 1.0, this.y + f3, this.z + 1.0));
        }
        if (side == 3) {
            return bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f2, this.z, this.x + 1.0, this.y + f3, this.z + 0.5));
        }
        return false;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }
}

