/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.level.particle.ExplodeParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import java.util.ArrayDeque;
import java.util.Map;

public class BlockSponge
extends BlockSolidMeta {
    public static final int DRY = 0;
    public static final int WET = 1;
    private static final String[] NAMES = new String[]{"Sponge", "Wet sponge"};

    public BlockSponge() {
        this(0);
    }

    public BlockSponge(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 19;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 1];
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.CLOTH_BLOCK_COLOR;
    }

    @Override
    public int getToolType() {
        return 6;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.getDamage() == 1 && this.level.getDimension() == 1) {
            this.level.setBlock(block, Block.get(19, 0), true, true);
            this.level.addLevelSoundEvent(block, 27);
            this.level.addParticle(new ExplodeParticle(block.add(0.5, 1.0, 0.5)));
            return true;
        }
        if (this.getDamage() == 0 && this.performWaterAbsorb(block)) {
            this.level.setBlock(block, Block.get(19, 1), true, true);
            Map<Integer, Player> players = this.level.getChunkPlayers(block.getChunkX(), block.getChunkZ());
            this.level.addParticle((Particle)new DestroyBlockParticle(block.add(0.5, 0.5, 0.5), Block.get(8)), players.values().toArray(new Player[0]));
            return true;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    private boolean performWaterAbsorb(Block block) {
        Entry entry;
        boolean waterFound = false;
        for (BlockFace side : BlockFace.values()) {
            if (!(this.getSide(side) instanceof BlockWater)) continue;
            waterFound = true;
            break;
        }
        if (!waterFound) {
            return false;
        }
        ArrayDeque<Entry> entries = new ArrayDeque<Entry>();
        entries.add(new Entry(block, 0));
        int waterRemoved = 0;
        while (waterRemoved < 64 && (entry = (Entry)entries.poll()) != null) {
            for (BlockFace face : BlockFace.values()) {
                Block faceBlock = entry.block.getSide(face);
                if (Block.isWater(faceBlock.getId())) {
                    this.level.setBlock(faceBlock, Block.get(0));
                    ++waterRemoved;
                    if (entry.distance >= 6) continue;
                    entries.add(new Entry(faceBlock, entry.distance + 1));
                    continue;
                }
                if (faceBlock.getId() != 0 || entry.distance >= 6) continue;
                entries.add(new Entry(faceBlock, entry.distance + 1));
            }
        }
        return waterRemoved > 0;
    }

    private static class Entry {
        private final Block block;
        private final int distance;

        public Entry(Block block, int distance) {
            this.block = block;
            this.distance = distance;
        }
    }
}

