/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockFormEvent;
import cn.nukkit.utils.BlockColor;

public class BlockSoulSand
extends BlockSolid {
    @Override
    public String getName() {
        return "Soul Sand";
    }

    @Override
    public int getId() {
        return 88;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 0.5;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.875;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.motionX *= 0.4;
        entity.motionZ *= 0.4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.BROWN_BLOCK_COLOR;
    }

    @Override
    public int onUpdate(int type) {
        Block up;
        if (type == 1 && (up = this.up()) instanceof BlockWater && (up.getDamage() == 0 || up.getDamage() == 8)) {
            BlockFormEvent event = new BlockFormEvent(up, Block.get(415, 0));
            Server.getInstance().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.getLevel().setBlock(up, event.getNewState(), false, true);
            }
        }
        return 0;
    }
}

