/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockSlabCopperBase;
import cn.nukkit.block.properties.OxidizationLevel;

public class BlockSlabCopperCut
extends BlockSlabCopperBase {
    public BlockSlabCopperCut() {
        this(0);
    }

    public BlockSlabCopperCut(int meta) {
        super(meta, 623);
    }

    protected BlockSlabCopperCut(int meta, int doubleSlab) {
        super(meta, doubleSlab);
    }

    @Override
    public int getId() {
        return 616;
    }

    @Override
    public String getSlabName() {
        OxidizationLevel oxidizationLevel;
        String name = "";
        if (this.isWaxed()) {
            name = name + "Waxed ";
        }
        if ((oxidizationLevel = this.getOxidizationLevel()) != OxidizationLevel.UNAFFECTED) {
            String oxidationName = oxidizationLevel.name();
            name = name + oxidationName.charAt(0) + oxidationName.substring(1).toLowerCase();
        }
        return name + " Cut Copper";
    }

    @Override
    protected int getCopperId(boolean waxed, OxidizationLevel oxidizationLevel) {
        if (oxidizationLevel == null) {
            return this.getId();
        }
        switch (oxidizationLevel) {
            case UNAFFECTED: {
                return waxed ? 620 : 616;
            }
            case EXPOSED: {
                return waxed ? 621 : 617;
            }
            case WEATHERED: {
                return waxed ? 622 : 618;
            }
            case OXIDIZED: {
                return waxed ? 704 : 619;
            }
        }
        return this.getId();
    }

    @Override
    public OxidizationLevel getOxidizationLevel() {
        return OxidizationLevel.UNAFFECTED;
    }
}

