/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.utils.BlockColor;

public class BlockSlabBlackstone
extends BlockSlab {
    public BlockSlabBlackstone() {
        this(0);
    }

    public BlockSlabBlackstone(int meta) {
        super(meta, 538);
    }

    @Override
    public int getId() {
        return 537;
    }

    @Override
    public boolean hasTopBit() {
        return (this.getDamage() & 1) == 1;
    }

    @Override
    public void setTopBit(boolean topBit) {
        this.setDamage(topBit ? 1 : 0);
    }

    @Override
    public String getName() {
        return "Blackstone Slab";
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe()) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.BLACK_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

