/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;

public abstract class BlockSlab
extends BlockTransparentMeta {
    protected final int doubleSlab;

    public BlockSlab(int meta, int doubleSlab) {
        super(meta);
        this.doubleSlab = doubleSlab;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        if (this.hasTopBit()) {
            return new SimpleAxisAlignedBB(this.x, this.y + 0.5, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
        }
        return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 0.5, this.z + 1.0);
    }

    public String getSlabName() {
        return "";
    }

    @Override
    public String getName() {
        return (this.hasTopBit() ? "Upper " : "") + this.getSlabName() + " Slab";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return this.getToolType() < 4 ? 30.0 : 15.0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(this.getDamage() & 7);
        if (face == BlockFace.DOWN) {
            if (target instanceof BlockSlab && ((BlockSlab)target).doubleSlab == this.doubleSlab && ((BlockSlab)target).hasTopBit() && (target.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock(target, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
            if (block instanceof BlockSlab && ((BlockSlab)block).doubleSlab == this.doubleSlab && (block.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock(block, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
            this.setTopBit(true);
        } else if (face == BlockFace.UP) {
            if (target instanceof BlockSlab && ((BlockSlab)target).doubleSlab == this.doubleSlab && !((BlockSlab)target).hasTopBit() && (target.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock(target, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
            if (block instanceof BlockSlab && ((BlockSlab)block).doubleSlab == this.doubleSlab && (block.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock(block, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
        } else {
            if (block instanceof BlockSlab && ((BlockSlab)block).doubleSlab == this.doubleSlab) {
                if ((block.getDamage() & 7) == (this.getDamage() & 7)) {
                    this.getLevel().setBlock(block, Block.get(this.doubleSlab, this.getDamage()), true);
                    return true;
                }
                return false;
            }
            if (fy > 0.5) {
                this.setTopBit(true);
            }
        }
        if (block instanceof BlockSlab && ((BlockSlab)block).doubleSlab == this.doubleSlab && (target.getDamage() & 7) != (this.getDamage() & 7)) {
            return false;
        }
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    public boolean hasTopBit() {
        return (this.getDamage() & 8) > 0;
    }

    public void setTopBit(boolean topBit) {
        if (topBit) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() & 7);
        }
    }

    @Override
    public Item toItem() {
        int damage = this.getDamage() & 7;
        return new ItemBlock(Block.get(this.getId(), damage), damage);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }
}

