/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySkull;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSkull;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockSkull
extends BlockTransparentMeta
implements Faceable {
    public BlockSkull() {
        this(0);
    }

    public BlockSkull(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 144;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public String getName() {
        BlockEntity blockEntity;
        int itemMeta = 0;
        if (this.level != null && (blockEntity = this.getLevel().getBlockEntity(this)) != null) {
            itemMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return ItemSkull.getItemSkullName(itemMeta);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        switch (face) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: 
            case UP: {
                this.setDamage(face.getIndex());
                break;
            }
            default: {
                return false;
            }
        }
        this.getLevel().setBlock(this, this, true, true);
        CompoundTag nbt = new CompoundTag().putString("id", "Skull").putByte("SkullType", item.getDamage()).putInt("x", block.getFloorX()).putInt("y", block.getFloorY()).putInt("z", block.getFloorZ()).putByte("Rot", (int)Math.floor(player.yaw * 16.0 / 360.0 + 0.5) & 0xF);
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        BlockEntitySkull blockEntity = (BlockEntitySkull)BlockEntity.createBlockEntity("Skull", this.getChunk(), nbt, new Object[0]);
        blockEntity.spawnToAll();
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        int dropMeta = 0;
        if (blockEntity != null) {
            dropMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return new Item[]{Item.get(397, (Integer)dropMeta)};
    }

    @Override
    public Item toItem() {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        int itemMeta = 0;
        if (blockEntity != null) {
            itemMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return Item.get(397, (Integer)itemMeta);
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        SimpleAxisAlignedBB bb = new SimpleAxisAlignedBB(this.x + 0.25, this.y, this.z + 0.25, this.x + 1.0 - 0.25, this.y + 0.5, this.z + 1.0 - 0.25);
        switch (this.getBlockFace()) {
            case NORTH: {
                return bb.offset(0.0, 0.25, 0.25);
            }
            case SOUTH: {
                return bb.offset(0.0, 0.25, -0.25);
            }
            case WEST: {
                return bb.offset(0.25, 0.25, 0.0);
            }
            case EAST: {
                return bb.offset(-0.25, 0.25, 0.0);
            }
        }
        return bb;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public boolean alwaysDropsOnExplosion() {
        return true;
    }
}

