/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySign;
import cn.nukkit.event.block.SignColorChangeEvent;
import cn.nukkit.event.block.SignGlowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.OpenSignPacket;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;

public class BlockSignPost
extends BlockTransparentMeta
implements Faceable {
    public BlockSignPost() {
        this(0);
    }

    public BlockSignPost(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 63;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public String getName() {
        return "Sign Post";
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    protected int getPostId() {
        return 63;
    }

    protected int getWallId() {
        return 68;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (face != BlockFace.DOWN) {
            CompoundTag nbt = new CompoundTag().putString("id", "Sign").putInt("x", (int)block.x).putInt("y", (int)block.y).putInt("z", (int)block.z).putString("Text1", "").putString("Text2", "").putString("Text3", "").putString("Text4", "");
            if (face == BlockFace.UP) {
                this.setDamage((int)Math.floor((player.yaw + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
                this.getLevel().setBlock(block, Block.get(this.getPostId(), this.getDamage()), true);
            } else if (target.canBeReplaced()) {
                this.setDamage((int)Math.floor((player.yaw + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
                this.getLevel().setBlock(target, Block.get(this.getPostId(), this.getDamage()), true);
            } else {
                this.setDamage(face.getIndex());
                this.getLevel().setBlock(block, Block.get(this.getWallId(), this.getDamage()), true);
            }
            if (player != null) {
                nbt.putString("Creator", player.getUniqueId().toString());
            }
            if (item.hasCustomBlockData()) {
                for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                    nbt.put(aTag.getName(), aTag);
                }
            }
            BlockEntity.createBlockEntity("Sign", this.getChunk(), nbt, new Object[0]);
            if (player != null) {
                OpenSignPacket pk = new OpenSignPacket();
                pk.position = this.asBlockVector3();
                pk.frontSide = true;
                player.dataPacket(pk);
            }
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return Item.get(323);
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351) {
            BlockEntity blockEntity = this.level.getBlockEntityIfLoaded(player == null ? null : player.chunk, this);
            if (!(blockEntity instanceof BlockEntitySign)) {
                return false;
            }
            BlockEntitySign sign = (BlockEntitySign)blockEntity;
            int meta = item.getDamage();
            if (meta == 0 || meta == 20) {
                boolean glow;
                boolean bl = glow = meta == 20;
                if (sign.isGlowing() == glow) {
                    if (player != null) {
                        sign.spawnTo(player);
                    }
                    return false;
                }
                SignGlowEvent event = new SignGlowEvent(this, player, glow);
                this.level.getServer().getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    return false;
                }
                sign.setGlowing(glow);
                sign.spawnToAll();
                this.level.addLevelEvent(this, 1066);
                if (player != null && (player.getGamemode() & 1) == 0) {
                    --item.count;
                }
                return true;
            }
            BlockColor color = DyeColor.getByDyeData(meta).getSignColor();
            if (color.equals(sign.getColor())) {
                return false;
            }
            SignColorChangeEvent event = new SignColorChangeEvent(this, player, color);
            this.level.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                if (player != null) {
                    sign.spawnTo(player);
                }
                return false;
            }
            sign.setColor(color);
            sign.spawnToAll();
            this.level.addLevelEvent(this, 1065);
            if (player != null && (player.getGamemode() & 1) == 0) {
                --item.count;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

