/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityShulkerBox;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;

public class BlockShulkerBox
extends BlockTransparentMeta {
    public BlockShulkerBox() {
        this(0);
    }

    public BlockShulkerBox(int meta) {
        super(meta);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getId() {
        return 218;
    }

    @Override
    public String getName() {
        return this.getDyeColor().getName() + " Shulker Box";
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public Item toItem() {
        ItemBlock item = new ItemBlock((Block)this, this.getDamage(), 1);
        BlockEntity be = this.getLevel().getBlockEntity(this);
        if (be instanceof BlockEntityShulkerBox) {
            BlockEntityShulkerBox t2 = (BlockEntityShulkerBox)be;
            BaseInventory i = t2.getInventory();
            if (!i.slots.isEmpty()) {
                CompoundTag nbt = item.getNamedTag();
                if (nbt == null) {
                    nbt = new CompoundTag("");
                }
                ListTag<CompoundTag> items = new ListTag<CompoundTag>();
                for (int it = 0; it < i.getSize(); ++it) {
                    if (i.getItem(it).getId() == 0) continue;
                    CompoundTag d = NBTIO.putItemHelper(i.getItem(it), it);
                    items.add(d);
                }
                nbt.put("Items", items);
                item.setCompoundTag(nbt);
            }
            if (t2.hasName()) {
                item.setCustomName(t2.getName());
            }
        }
        return item;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        CompoundTag t2;
        this.getLevel().setBlock(this, this, true, true);
        CompoundTag nbt = BlockEntity.getDefaultCompound(this, "ShulkerBox").putByte("facing", face.getIndex());
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if ((t2 = item.getNamedTag()) != null && t2.contains("Items")) {
            nbt.putList(t2.getList("Items"));
        }
        BlockEntity.createBlockEntity("ShulkerBox", this.getChunk(), nbt, new Object[0]);
        return true;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntity t2 = this.getLevel().getBlockEntity(this);
            if (!(t2 instanceof BlockEntityShulkerBox)) {
                return false;
            }
            BlockEntityShulkerBox box = (BlockEntityShulkerBox)t2;
            Block block = this.getSide(BlockFace.fromIndex(box.namedTag.getByte("facing")));
            if (!(block instanceof BlockAir || block instanceof BlockLiquid || block instanceof BlockFlowable)) {
                return true;
            }
            player.addWindow(box.getInventory());
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        return DyeColor.getByWoolData(this.getDamage());
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public boolean alwaysDropsOnExplosion() {
        return true;
    }
}

