/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockSeagrass
extends BlockFlowable {
    public BlockSeagrass() {
        this(0);
    }

    public BlockSeagrass(int meta) {
        super(meta % 3);
    }

    @Override
    public String getName() {
        return "Seagrass";
    }

    @Override
    public int getId() {
        return 385;
    }

    @Override
    public int getToolType() {
        return 359;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        int waterDamage;
        if (this.level != null && this.level.getProvider() instanceof Anvil) {
            if (!(block instanceof BlockWater) || block.getDamage() != 0 || this.down().isTransparent()) {
                return false;
            }
            return this.getLevel().setBlock(this, this, true, true);
        }
        Block down = this.down();
        Block layer1Block = block.getLevelBlock(BlockLayer.WATERLOGGED);
        if (down.isSolid() && down.getId() != 213 && down.getId() != 88 && layer1Block instanceof BlockWater && ((waterDamage = block.getDamage()) == 0 || waterDamage == 8)) {
            if (waterDamage == 8) {
                this.getLevel().setBlock((int)this.x, (int)this.y, (int)this.z, Block.LAYER_WATERLOGGED, Block.get(9), true, true);
            }
            this.getLevel().setBlock(this, BlockLayer.NORMAL, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (this.level != null && this.level.getProvider() instanceof Anvil) {
            Block down;
            if (type == 1 && (down = this.down()).isTransparent() && down.getId() != 385) {
                this.getLevel().useBreakOn(this);
            }
            return type;
        }
        if (type == 1) {
            int damage;
            Block blockLayer1 = this.getLevelBlock(BlockLayer.WATERLOGGED);
            if (!(blockLayer1 instanceof BlockIceFrosted) && (!(blockLayer1 instanceof BlockWater) || (damage = blockLayer1.getDamage()) != 0 && damage != 8)) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
            Block down = this.down();
            damage = this.getDamage();
            if (damage == 0 || damage == 2) {
                Block up;
                if (!down.isSolid() || down.getId() == 213 || down.getId() == 88) {
                    this.getLevel().useBreakOn(this);
                    return 1;
                }
                if (damage == 2 && ((up = this.up()).getId() != this.getId() || up.getDamage() != 1)) {
                    this.getLevel().useBreakOn(this);
                }
            } else if (down.getId() != this.getId() || down.getDamage() != 2) {
                this.getLevel().useBreakOn(this);
            }
            return 1;
        }
        return 0;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(385), 0, 1);
    }

    @Override
    public void setDamage(int meta) {
        super.setDamage(meta % 3);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.FLOW_INTO_BLOCK;
    }

    @Override
    public boolean canBeFlowedInto() {
        return this.level == null || !(this.level.getProvider() instanceof Anvil);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WATER_BLOCK_COLOR;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return this.getDamage() == 0;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (this.getDamage() == 0 && item.getId() == 351 && item.getDamage() == 15 && this.up() instanceof BlockWater) {
            Vector3 up = this.getSideVec(BlockFace.UP);
            if (this.level.setBlock(up, Block.get(385, 1), true, true)) {
                this.level.setBlock(this, Block.get(385, 2), true, true);
            }
            if (player != null && !player.isCreative()) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            return true;
        }
        return false;
    }
}

