/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.block.BlockSpreadEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import java.util.concurrent.ThreadLocalRandom;

public class BlockSeaPickle
extends BlockTransparentMeta {
    public BlockSeaPickle() {
        this(0);
    }

    public BlockSeaPickle(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 411;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public String getName() {
        return "Sea Pickle";
    }

    public boolean isDead() {
        return (this.getDamage() & 4) == 4;
    }

    public void setDead(boolean dead) {
        if (dead) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() ^ 4);
        }
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block down = this.down();
            if (!down.isSolid() || down.getId() == 213) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            Block layer1 = this.getLevelBlock(Block.LAYER_WATERLOGGED);
            if (layer1 instanceof BlockWater) {
                if (this.isDead() || layer1.getDamage() == 0 && layer1.getDamage() == 8) {
                    this.getLevel().useBreakOn(this);
                    return type;
                }
            } else if (!this.isDead()) {
                BlockFadeEvent event = new BlockFadeEvent(this, Block.get(411, this.getDamage() ^ 4));
                this.level.getServer().getPluginManager().callEvent(event);
                if (!event.isCancelled()) {
                    this.getLevel().setBlock(this, event.getNewState(), true, true);
                }
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.getId() == 411 && (target.getDamage() & 3) < 3) {
            target.setDamage(target.getDamage() + 1);
            this.getLevel().setBlock(target, target, true, true);
            return true;
        }
        if (!this.down().isTransparent()) {
            Block layer1 = block.getLevelBlock(BlockLayer.WATERLOGGED);
            if (layer1 instanceof BlockWater) {
                if (layer1.getDamage() != 0 && layer1.getDamage() != 8) {
                    return false;
                }
                if (layer1.getDamage() == 8) {
                    this.getLevel().setBlock(block, BlockLayer.WATERLOGGED, Block.get(8), true, false);
                }
            } else {
                this.setDead(true);
            }
            this.getLevel().setBlock(block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block[] blocksAround;
        if (item.getId() != 351 || item.getDamage() != 15) {
            return super.onActivate(item, player);
        }
        BlockSeaPickle block = (BlockSeaPickle)this.clone();
        if (!block.isDead()) {
            block.setDamage(3);
        }
        BlockGrowEvent blockGrowEvent = new BlockGrowEvent(this, block);
        this.level.getServer().getPluginManager().callEvent(blockGrowEvent);
        if (blockGrowEvent.isCancelled()) {
            return false;
        }
        this.getLevel().setBlock(this, blockGrowEvent.getNewState(), false, true);
        this.level.addParticle(new BoneMealParticle(this));
        if (player != null && !player.isCreative()) {
            --item.count;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (Block blockNearby : blocksAround = this.getLevel().getCollisionBlocks(new SimpleAxisAlignedBB(this.x - 2.0, this.y - 2.0, this.z - 2.0, this.x + 3.0, this.y, this.z + 3.0))) {
            BlockSpreadEvent blockSpreadEvent;
            Block up;
            if (blockNearby.getId() != 387 || !((up = blockNearby.up()) instanceof BlockWater) || up.getDamage() != 0 && up.getDamage() != 8 || random.nextInt(6) != 0 || (blockSpreadEvent = new BlockSpreadEvent(up, this, Block.get(411, random.nextInt(3)))).isCancelled()) continue;
            this.getLevel().setBlock(up, BlockLayer.WATERLOGGED, Block.get(8), true, false);
            this.getLevel().setBlock(up, blockSpreadEvent.getNewState(), true, true);
        }
        return true;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(411), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{new ItemBlock(Block.get(411), 0, (this.getDamage() & 3) + 1)};
    }

    @Override
    public int getLightLevel() {
        if (this.isDead()) {
            return 0;
        }
        return (this.getDamage() + 1) * 3;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

