/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallableMeta;
import cn.nukkit.block.BlockLava;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockScaffolding
extends BlockFallableMeta {
    public BlockScaffolding() {
        this(0);
    }

    public BlockScaffolding(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Scaffolding";
    }

    @Override
    public int getId() {
        return 420;
    }

    public int getStability() {
        return this.getDamage() & 7;
    }

    public void setStability(int stability) {
        this.setDamage(stability & 7 | this.getDamage() & 8);
    }

    public boolean getStabilityCheck() {
        return (this.getDamage() & 8) > 0;
    }

    public void setStabilityCheck(boolean check) {
        if (check) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() & 7);
        }
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(420));
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block instanceof BlockLava) {
            return false;
        }
        Block down = this.down();
        if (target.getId() != 420 && down.getId() != 420 && down.getId() != 0 && !down.isSolid()) {
            boolean scaffoldOnSide = false;
            for (int i = 0; i < 4; ++i) {
                Block side;
                BlockFace sideFace = BlockFace.fromHorizontalIndex(i);
                if (sideFace == face || (side = this.getSide(sideFace)).getId() != 420) continue;
                scaffoldOnSide = true;
                break;
            }
            if (!scaffoldOnSide) {
                return false;
            }
        }
        this.setDamage(8);
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block down = this.down();
            if (down.isSolid()) {
                if (this.getDamage() != 0) {
                    this.setDamage(0);
                    this.getLevel().setBlock(this, this, true, true);
                }
                return type;
            }
            int stability = 7;
            for (BlockFace face : BlockFace.values()) {
                BlockScaffolding other;
                int otherStability;
                Block otherBlock;
                if (face == BlockFace.UP || (otherBlock = this.getSide(face)).getId() != 420 || (otherStability = (other = (BlockScaffolding)otherBlock).getStability()) >= stability) continue;
                stability = face == BlockFace.DOWN ? otherStability : otherStability + 1;
            }
            if (stability >= 7) {
                if (this.getStabilityCheck()) {
                    super.onUpdate(type);
                } else {
                    this.getLevel().scheduleUpdate(this, 0);
                }
                return type;
            }
            this.setStabilityCheck(false);
            this.setStability(stability);
            this.getLevel().setBlock(this, this, true, true);
            return type;
        }
        if (type == 3) {
            this.getLevel().useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public int getBurnChance() {
        return 60;
    }

    @Override
    public int getBurnAbility() {
        return 60;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean canBeClimbed() {
        return true;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.resetFallDistance();
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public double getMinY() {
        return this.y + 0.875;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.TRANSPARENT_BLOCK_COLOR;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getBlockUnsafe() instanceof BlockScaffolding) {
            int id;
            int i;
            int top = (int)this.y;
            for (i = 1; i <= 16 && (id = this.level.getBlockIdAt(this.getFloorX(), this.getFloorY() - i, this.getFloorZ())) == 420; ++i) {
            }
            for (i = 1; i <= 16 && (id = this.level.getBlockIdAt(this.getFloorX(), this.getFloorY() + i, this.getFloorZ())) == 420; ++i) {
                ++top;
            }
            boolean success = false;
            Block block = this.up(top - (int)this.y + 1);
            if (block.getId() == 0) {
                success = this.level.setBlock(block, Block.get(420));
            }
            if (success && player != null && !player.isCreative()) {
                --item.count;
            }
            return true;
        }
        return false;
    }
}

