/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockMangrovePropagule;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.level.StructureGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.ListChunkManager;
import cn.nukkit.level.generator.object.BasicGenerator;
import cn.nukkit.level.generator.object.tree.HugeTreesGenerator;
import cn.nukkit.level.generator.object.tree.NewJungleTree;
import cn.nukkit.level.generator.object.tree.ObjectBigSpruceTree;
import cn.nukkit.level.generator.object.tree.ObjectDarkOakTree;
import cn.nukkit.level.generator.object.tree.ObjectJungleBigTree;
import cn.nukkit.level.generator.object.tree.ObjectSavannaTree;
import cn.nukkit.level.generator.object.tree.ObjectTree;
import cn.nukkit.level.generator.object.tree.TreeGenerator;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;
import java.util.concurrent.ThreadLocalRandom;

public class BlockSapling
extends BlockFlowable {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;
    public static final int ACACIA = 4;
    public static final int DARK_OAK = 5;
    public static final int BIRCH_TALL = 10;
    private static final String[] NAMES = new String[]{"Oak Sapling", "Spruce Sapling", "Birch Sapling", "Jungle Sapling", "Acacia Sapling", "Dark Oak Sapling", "", ""};
    private static final Vector2[][] VALID_SAPLINGS = new Vector2[4][4];

    public BlockSapling() {
        this(0);
    }

    public BlockSapling(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 7];
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!(this instanceof BlockMangrovePropagule) && (block instanceof BlockWater || block.level.isBlockWaterloggedAt(block.getChunk(), (int)block.x, (int)block.y, (int)block.z))) {
            return false;
        }
        Block down = this.down();
        int id = down.getId();
        if (id == 2 || id == 3 || id == 60 || id == 243 || id == 110 || id == 575 || id == 728) {
            this.getLevel().setBlock(block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            if (player != null && !player.isCreative()) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            if ((double)ThreadLocalRandom.current().nextFloat() >= 0.45) {
                return true;
            }
            return this.growTreeHere();
        }
        return false;
    }

    private boolean growTreeHere() {
        TreeGenerator generator = null;
        boolean bigTree = false;
        Vector3 vector3 = new Vector3(this.x, this.y - 1.0, this.z);
        int woodType = this.getDamage() & 7;
        switch (woodType) {
            case 3: {
                Vector2 vector2 = this.findSaplings(3);
                if (vector2 != null) {
                    vector3 = this.add(vector2.getFloorX(), 0.0, vector2.getFloorY());
                    generator = new ObjectJungleBigTree(10, 20, Block.get(17, 3), Block.get(18, 3));
                    bigTree = true;
                }
                if (bigTree) break;
                generator = new NewJungleTree(4, 7);
                vector3 = this.add(0.0, 0.0, 0.0);
                break;
            }
            case 4: {
                generator = new ObjectSavannaTree();
                vector3 = this.add(0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                Vector2 vector2 = this.findSaplings(5);
                if (vector2 != null) {
                    vector3 = this.add(vector2.getFloorX(), 0.0, vector2.getFloorY());
                    generator = new ObjectDarkOakTree();
                    bigTree = true;
                }
                if (bigTree) break;
                return false;
            }
            case 1: {
                Vector2 vector2 = this.findSaplings(1);
                if (vector2 != null) {
                    vector3 = this.add(vector2.getFloorX(), 0.0, vector2.getFloorY());
                    generator = new HugeTreesGenerator(0, 0, null, null){

                        @Override
                        public boolean generate(ChunkManager level, NukkitRandom rand, Vector3 position) {
                            ObjectBigSpruceTree object = new ObjectBigSpruceTree(0.25f, 4);
                            if (!this.ensureGrowable(level, position, object.getTreeHeight())) {
                                return false;
                            }
                            object.placeObject(level, position.getFloorX(), position.getFloorY(), position.getFloorZ(), rand);
                            return true;
                        }
                    };
                    bigTree = true;
                }
                if (bigTree) break;
            }
            default: {
                ListChunkManager chunkManager = new ListChunkManager(this.level);
                ObjectTree.growTree(chunkManager, this.getFloorX(), this.getFloorY(), this.getFloorZ(), new NukkitRandom(), woodType);
                StructureGrowEvent ev = new StructureGrowEvent(this, chunkManager.getBlocks());
                this.level.getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                for (Block block : ev.getBlockList()) {
                    this.level.setBlock(block, block);
                }
                return true;
            }
        }
        if (bigTree) {
            this.level.setBlock(vector3, Block.get(0), true, false);
            this.level.setBlock(vector3.add(1.0, 0.0, 0.0), Block.get(0), true, false);
            this.level.setBlock(vector3.add(0.0, 0.0, 1.0), Block.get(0), true, false);
            this.level.setBlock(vector3.add(1.0, 0.0, 1.0), Block.get(0), true, false);
        } else {
            this.level.setBlock(this, Block.get(0), true, false);
        }
        ListChunkManager chunkManager = new ListChunkManager(this.level);
        boolean success = ((BasicGenerator)generator).generate(chunkManager, new NukkitRandom(), vector3);
        StructureGrowEvent ev = new StructureGrowEvent(this, chunkManager.getBlocks());
        this.level.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled() || !success) {
            if (bigTree) {
                this.level.setBlock(vector3, this, true, false);
                this.level.setBlock(vector3.add(1.0, 0.0, 0.0), this, true, false);
                this.level.setBlock(vector3.add(0.0, 0.0, 1.0), this, true, false);
                this.level.setBlock(vector3.add(1.0, 0.0, 1.0), this, true, false);
            } else {
                this.level.setBlock(this, this, true, false);
            }
            return false;
        }
        for (Block block : ev.getBlockList()) {
            this.level.setBlock(block, block);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.down().isTransparent()) return 1;
            this.getLevel().useBreakOn(this);
            return 1;
        }
        if (type != 2) return 1;
        if (Utils.rand(1, 7) != 1) return 2;
        if ((this.getDamage() & 8) == 8) {
            this.growTreeHere();
            return 1;
        } else {
            this.setDamage(this.getDamage() | 8);
            this.getLevel().setBlock(this, this, true);
            return 2;
        }
    }

    public boolean isSameType(Vector3 pos, int type) {
        Block block = this.level.getBlock(pos);
        return block.getId() == this.getId() && (block.getDamage() & 7) == (type & 7);
    }

    @Override
    public Item toItem() {
        return Item.get(6, (Integer)(this.getDamage() & 7));
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    private Vector2 findSaplings(int type) {
        for (Vector2[] validVectors : VALID_SAPLINGS) {
            boolean found = true;
            for (Vector2 vector2 : validVectors) {
                if (this.isSameType(this.add(vector2.x, 0.0, vector2.y), type)) continue;
                found = false;
            }
            if (!found) continue;
            int lowestX = 0;
            int lowestZ = 0;
            for (Vector2 vector2 : validVectors) {
                if (vector2.getFloorX() < lowestX) {
                    lowestX = vector2.getFloorX();
                }
                if (vector2.getFloorY() >= lowestZ) continue;
                lowestZ = vector2.getFloorY();
            }
            return new Vector2(lowestX, lowestZ);
        }
        return null;
    }

    static {
        BlockSapling.VALID_SAPLINGS[0] = new Vector2[]{new Vector2(0.0, 0.0), new Vector2(1.0, 0.0), new Vector2(0.0, 1.0), new Vector2(1.0, 1.0)};
        BlockSapling.VALID_SAPLINGS[1] = new Vector2[]{new Vector2(0.0, 0.0), new Vector2(-1.0, 0.0), new Vector2(0.0, -1.0), new Vector2(-1.0, -1.0)};
        BlockSapling.VALID_SAPLINGS[2] = new Vector2[]{new Vector2(0.0, 0.0), new Vector2(1.0, 0.0), new Vector2(0.0, -1.0), new Vector2(1.0, -1.0)};
        BlockSapling.VALID_SAPLINGS[3] = new Vector2[]{new Vector2(0.0, 0.0), new Vector2(-1.0, 0.0), new Vector2(0.0, 1.0), new Vector2(-1.0, 1.0)};
    }
}

