/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallableMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.level.generator.object.ObjectTallGrass;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.utils.BlockColor;

public class BlockSand
extends BlockFallableMeta {
    public static final int DEFAULT = 0;
    public static final int RED = 1;

    public BlockSand() {
        this(0);
    }

    public BlockSand(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public String getName() {
        if (this.getDamage() == 1) {
            return "Red Sand";
        }
        return "Sand";
    }

    @Override
    public BlockColor getColor() {
        if (this.getDamage() == 1) {
            return BlockColor.ORANGE_BLOCK_COLOR;
        }
        return BlockColor.SAND_BLOCK_COLOR;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block up;
        if (player != null && item.getId() == 351 && item.getDamage() == 15 && (up = this.up()) instanceof BlockWater) {
            if (!player.isCreative()) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            if (up.getDamage() == 0 && up.up() instanceof BlockWater) {
                ObjectTallGrass.growSeagrass(this.getLevel(), this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }
}

