/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Explosion;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Position;

public class BlockRespawnAnchor
extends BlockSolidMeta {
    public BlockRespawnAnchor() {
        this(0);
    }

    public BlockRespawnAnchor(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 527;
    }

    @Override
    public double getHardness() {
        return 50.0;
    }

    @Override
    public double getResistance() {
        return 1200.0;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 5) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public int getLightLevel() {
        switch (this.getDamage()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 7;
            }
        }
        return 15;
    }

    @Override
    public String getName() {
        return "Respawn Anchor";
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        int chargeLevel = this.getDamage();
        if (item.getId() == 89 && chargeLevel < 4) {
            if (player != null && !player.isCreative()) {
                --item.count;
            }
            this.setDamage(chargeLevel + 1);
            this.getLevel().setBlock(this, this, true);
            this.getLevel().addLevelSoundEvent(this, 308);
            return true;
        }
        if (chargeLevel > 0 && this.level.getDimension() != 1) {
            if (this.level.getGameRules().getBoolean(GameRule.RESPAWN_BLOCKS_EXPLODE)) {
                this.getLevel().setBlock(this, Block.get(0), true, true);
                Explosion explosion = new Explosion(this.add(0.5, 0.0, 0.5), 5.0, this);
                explosion.explodeA();
                explosion.explodeB();
            }
            return true;
        }
        if (player != null && chargeLevel > 0 && this.level.getDimension() == 1) {
            if (player.distanceSquared(this) > 36.0) {
                return false;
            }
            if (!this.equals(player.getSpawnPosition())) {
                player.setSpawn(this);
                player.sendMessage("\u00a77%tile.respawn_anchor.respawnSet", true);
                this.getLevel().addLevelSoundEvent(this, 310);
            }
        }
        return item.getId() == 89;
    }

    @Override
    public boolean onBreak(Item item) {
        boolean r = super.onBreak(item);
        if (r && this.level.getDimension() == 1) {
            Position safeSpawn = null;
            for (Player player : this.level.getServer().getOnlinePlayers().values()) {
                if (!this.equals(player.getSpawnPosition())) continue;
                player.setSpawn(safeSpawn == null ? this.level.getServer().getDefaultLevel().getSafeSpawn() : safeSpawn);
            }
        }
        return r;
    }
}

