/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.EnumSet;

public class BlockRedstoneWire
extends BlockFlowable {
    private boolean canProvidePower = true;

    public BlockRedstoneWire() {
        this(0);
    }

    public BlockRedstoneWire(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Redstone Wire";
    }

    @Override
    public int getId() {
        return 55;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block instanceof BlockWater || block.level.isBlockWaterloggedAt(block.getChunk(), (int)block.x, (int)block.y, (int)block.z)) {
            return false;
        }
        if (!BlockRedstoneWire.canStayOnFullSolid(block.down())) {
            return false;
        }
        this.getLevel().setBlock(block, this, true, false);
        this.calculateCurrentChanges(true);
        for (BlockFace blockFace : BlockFace.Plane.VERTICAL) {
            this.level.updateAroundRedstone(this.getSideVec(blockFace), blockFace.getOpposite());
        }
        for (BlockFace blockFace : BlockFace.Plane.VERTICAL) {
            this.updateAround(this.getSideVec(blockFace), blockFace.getOpposite());
        }
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            Vector3 v = this.getSideVec(blockFace);
            if (this.level.getBlock(v).isNormalBlock()) {
                this.updateAround(v.getSideVec(BlockFace.UP), BlockFace.DOWN);
                continue;
            }
            this.updateAround(v.getSideVec(BlockFace.DOWN), BlockFace.UP);
        }
        return true;
    }

    private void updateAround(Vector3 pos, BlockFace face) {
        if (this.level.getBlockIdAt((int)pos.x, (int)pos.y, (int)pos.z) == 55) {
            this.level.updateAroundRedstone(pos, face);
            for (BlockFace side : BlockFace.values()) {
                this.level.updateAroundRedstone(pos.getSideVec(side), side.getOpposite());
            }
        }
    }

    private void calculateCurrentChanges(boolean force) {
        block9: {
            block8: {
                int meta;
                int maxStrength = meta = this.getDamage();
                this.canProvidePower = false;
                int power = this.getIndirectPower();
                this.canProvidePower = true;
                if (power > 0 && power > maxStrength - 1) {
                    maxStrength = power;
                }
                int strength = 0;
                for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
                    Vector3 v = this.getSideVec(face);
                    if (v.getX() == this.getX() && v.getZ() == this.getZ()) continue;
                    strength = this.getMaxCurrentStrength(v, strength);
                    boolean vNormal = this.level.getBlock(v).isNormalBlock();
                    if (vNormal && !this.level.getBlock(this.getSideVec(BlockFace.UP)).isNormalBlock()) {
                        strength = this.getMaxCurrentStrength(v.getSideVec(BlockFace.UP), strength);
                        continue;
                    }
                    if (vNormal) continue;
                    strength = this.getMaxCurrentStrength(v.getSideVec(BlockFace.DOWN), strength);
                }
                maxStrength = strength > maxStrength ? strength - 1 : (maxStrength > 0 ? --maxStrength : 0);
                if (power > maxStrength - 1) {
                    maxStrength = power;
                } else if (power < maxStrength && strength <= maxStrength) {
                    maxStrength = Math.max(power, strength - 1);
                }
                if (meta == maxStrength) break block8;
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, meta, maxStrength));
                this.setDamage(maxStrength);
                this.level.setBlock(this, this, false, false);
                this.level.updateAroundRedstone(this, null);
                for (BlockFace face : BlockFace.values()) {
                    this.level.updateAroundRedstone(this.getSideVec(face), face.getOpposite());
                }
                break block9;
            }
            if (!force) break block9;
            for (BlockFace face : BlockFace.values()) {
                this.level.updateAroundRedstone(this.getSideVec(face), face.getOpposite());
            }
        }
    }

    private int getMaxCurrentStrength(Vector3 pos, int maxStrength) {
        if (this.level.getBlockIdAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ()) != 55) {
            return maxStrength;
        }
        int strength = this.level.getBlockDataAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
        return Math.max(strength, maxStrength);
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock(this, Block.get(0), true, true);
        this.level.updateAroundRedstone(this, null);
        for (BlockFace blockFace : BlockFace.values()) {
            this.level.updateAroundRedstone(this.getSideVec(blockFace), null);
        }
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            Vector3 v = this.getSideVec(blockFace);
            if (this.level.getBlock(v).isNormalBlock()) {
                this.updateAround(v.getSideVec(BlockFace.UP), BlockFace.DOWN);
                continue;
            }
            this.updateAround(v.getSideVec(BlockFace.DOWN), BlockFace.UP);
        }
        return true;
    }

    @Override
    public Item toItem() {
        return Item.get(331);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public int onUpdate(int type) {
        if (type != 1 && type != 6) {
            return 0;
        }
        if (type == 1 && !BlockRedstoneWire.canStayOnFullSolid(this.down())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
        this.getLevel().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return 0;
        }
        if (this.level.getBlockIdAt((int)this.x, (int)this.y, (int)this.z) != this.getId()) {
            return 0;
        }
        this.calculateCurrentChanges(false);
        return 6;
    }

    public boolean canBePlacedOn(Vector3 v) {
        return BlockRedstoneWire.canStayOnFullSolid(this.level.getBlock(v));
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.canProvidePower ? 0 : this.getWeakPower(side);
    }

    @Override
    public int getWeakPower(BlockFace side) {
        if (!this.canProvidePower) {
            return 0;
        }
        int power = this.getDamage();
        if (power == 0) {
            return 0;
        }
        if (side == BlockFace.UP) {
            return power;
        }
        EnumSet<BlockFace> enumset = EnumSet.noneOf(BlockFace.class);
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            if (!this.isPowerSourceAt(face)) continue;
            enumset.add(face);
        }
        if (side.getAxis().isHorizontal() && enumset.isEmpty()) {
            return power;
        }
        if (enumset.contains((Object)side) && !enumset.contains((Object)side.rotateYCCW()) && !enumset.contains((Object)side.rotateY())) {
            return power;
        }
        return 0;
    }

    private boolean isPowerSourceAt(BlockFace side) {
        Block sideBlock = this.getSide(side);
        boolean sideBlockIsNormal = sideBlock.isNormalBlock();
        return sideBlockIsNormal && !this.up().isNormalBlock() && BlockRedstoneWire.canConnectUpwardsTo(sideBlock.up()) || BlockRedstoneWire.canConnectTo(sideBlock, side) || !sideBlockIsNormal && BlockRedstoneWire.canConnectUpwardsTo(sideBlock.down());
    }

    protected static boolean canConnectUpwardsTo(Block block) {
        return BlockRedstoneWire.canConnectTo(block, null);
    }

    protected static boolean canConnectTo(Block block, BlockFace side) {
        if (block.getId() == 55) {
            return true;
        }
        if (BlockRedstoneDiode.isDiode(block)) {
            BlockFace face = ((BlockRedstoneDiode)block).getFacing();
            return face == side || face.getOpposite() == side;
        }
        return block.isPowerSource() && side != null;
    }

    @Override
    public boolean isPowerSource() {
        return this.canProvidePower;
    }

    private int getIndirectPower() {
        int power = 0;
        for (BlockFace face : BlockFace.values()) {
            int blockPower = this.getIndirectPower(this.getSideVec(face), face);
            if (blockPower >= 15) {
                return 15;
            }
            if (blockPower <= power) continue;
            power = blockPower;
        }
        return power;
    }

    private int getIndirectPower(Vector3 pos, BlockFace face) {
        Block block = this.level.getBlock(pos);
        if (block.getId() == 55) {
            return 0;
        }
        return block.isNormalBlock() ? this.getStrongPower(pos.getSideVec(face), face) : block.getWeakPower(face);
    }

    private int getStrongPower(Vector3 pos, BlockFace direction) {
        Block block = this.level.getBlock(pos);
        if (block.getId() == 55) {
            return 0;
        }
        return block.getStrongPower(direction);
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

