/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTorch;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;

public class BlockRedstoneTorchUnlit
extends BlockTorch {
    public BlockRedstoneTorchUnlit() {
        this(0);
    }

    public BlockRedstoneTorchUnlit(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Unlit Redstone Torch";
    }

    @Override
    public int getId() {
        return 75;
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(76));
    }

    @Override
    public int onUpdate(int type) {
        if (super.onUpdate(type) == 0) {
            if (type == 1 || type == 6) {
                this.level.scheduleUpdate(this, this.tickRate());
            } else if (type == 3) {
                RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
                this.getLevel().getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return 0;
                }
                if (this.checkState()) {
                    return 1;
                }
            }
        }
        return 0;
    }

    protected boolean checkState() {
        BlockFace face = this.getBlockFace().getOpposite();
        if (!this.level.isSidePowered(this.getSideVec(face), face)) {
            this.level.setBlock(this, Block.get(76, this.getDamage()), false, true);
            for (BlockFace side : BlockFace.values()) {
                if (side == face) continue;
                this.level.updateAroundRedstone(this.getSideVec(side), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public int tickRate() {
        return 2;
    }
}

