/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public abstract class BlockRedstoneDiode
extends BlockFlowable
implements Faceable {
    protected boolean isPowered = false;

    public BlockRedstoneDiode() {
        this(0);
    }

    public BlockRedstoneDiode(int meta) {
        super(meta);
    }

    @Override
    public boolean onBreak(Item item) {
        this.level.setBlock(this, Block.get(0), true, true);
        for (BlockFace face : BlockFace.values()) {
            this.level.updateAroundRedstone(this.getSideVec(face), null);
        }
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!BlockRedstoneDiode.canStayOnFullSolid(this.down())) {
            return false;
        }
        this.setDamage(player != null ? player.getDirection().getOpposite().getHorizontalIndex() : 0);
        this.level.setBlock(block, this, true, true);
        if (this.shouldBePowered()) {
            this.level.scheduleUpdate(this, 1);
        }
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            if (!this.isLocked()) {
                boolean shouldBePowered = this.shouldBePowered();
                if (this.isPowered && !shouldBePowered) {
                    this.level.setBlock(this, this.getUnpowered(), true, true);
                    this.level.updateAroundRedstone(this.getSideVec(this.getFacing().getOpposite()), null);
                } else if (!this.isPowered) {
                    this.level.setBlock(this, this.getPowered(), true, true);
                    this.level.updateAroundRedstone(this.getSideVec(this.getFacing().getOpposite()), null);
                    if (!shouldBePowered) {
                        this.level.scheduleUpdate(this.getPowered(), this, this.getDelay());
                    }
                }
            }
        } else if (type == 1 || type == 6) {
            RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
            this.getLevel().getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return 0;
            }
            if (type == 1 && !BlockRedstoneDiode.canStayOnFullSolid(this.down())) {
                this.level.useBreakOn(this);
            } else {
                this.updateState();
            }
            return 1;
        }
        return 0;
    }

    public void updateState() {
        if (!this.isLocked()) {
            boolean shouldPowered = this.shouldBePowered();
            if ((this.isPowered && !shouldPowered || !this.isPowered && shouldPowered) && !this.level.isBlockTickPending(this, this)) {
                this.level.scheduleUpdate(this, this, this.getDelay());
            }
        }
    }

    public boolean isLocked() {
        return false;
    }

    protected int calculateInputStrength() {
        BlockFace face = this.getFacing();
        Vector3 pos = this.getSideVec(face);
        int power = this.level.getRedstonePower(pos, face);
        if (power >= 15) {
            return power;
        }
        Block block = this.level.getBlock(pos);
        return Math.max(power, block.getId() == 55 ? block.getDamage() : 0);
    }

    protected int getPowerOnSides() {
        BlockFace face = this.getFacing();
        BlockFace face1 = face.rotateY();
        BlockFace face2 = face.rotateYCCW();
        return Math.max(this.getPowerOnSide(this.getSideVec(face1), face1), this.getPowerOnSide(this.getSideVec(face2), face2));
    }

    protected int getPowerOnSide(Vector3 pos, BlockFace side) {
        Block block = this.level.getBlock(pos);
        return this.isAlternateInput(block) ? (block.getId() == 152 ? 15 : (block.getId() == 55 ? block.getDamage() : this.level.getStrongPower(pos, side))) : 0;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    protected boolean shouldBePowered() {
        return this.calculateInputStrength() > 0;
    }

    public abstract BlockFace getFacing();

    protected abstract int getDelay();

    protected abstract Block getUnpowered();

    protected abstract Block getPowered();

    @Override
    public double getMaxY() {
        return this.y + 0.125;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    protected boolean isAlternateInput(Block block) {
        return block.isPowerSource();
    }

    public static boolean isDiode(Block block) {
        return block instanceof BlockRedstoneDiode;
    }

    protected int getRedstoneSignal() {
        return 15;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return this.getWeakPower(side);
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return !this.isPowered() ? 0 : (this.getFacing() == side ? this.getRedstoneSignal() : 0);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isFacingTowardsRepeater() {
        BlockFace side = this.getFacing().getOpposite();
        Block block = this.getSide(side);
        return block instanceof BlockRedstoneDiode && ((BlockRedstoneDiode)block).getFacing() != side;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.FLOW_INTO_BLOCK;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

