/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRail;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityMinecartAbstract;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;

public class BlockRailDetector
extends BlockRail {
    public BlockRailDetector() {
        this(0);
        this.canBePowered = true;
    }

    public BlockRailDetector(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 28;
    }

    @Override
    public String getName() {
        return "Detector Rail";
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isActive() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.isActive() ? 0 : (side == BlockFace.UP ? 15 : 0);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            this.updateState();
            return type;
        }
        return super.onUpdate(type);
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        this.updateState();
    }

    protected void updateState() {
        boolean wasPowered = this.isActive();
        boolean isPowered = false;
        boolean changed = false;
        for (Entity entity : this.level.getCollidingEntities(new SimpleAxisAlignedBB((double)this.getFloorX() + 0.125, this.getFloorY(), (double)this.getFloorZ() + 0.125, (double)this.getFloorX() + 0.875, (double)this.getFloorY() + 0.75, (double)this.getFloorZ() + 0.875))) {
            if (!(entity instanceof EntityMinecartAbstract)) continue;
            isPowered = true;
            break;
        }
        if (isPowered && !wasPowered) {
            this.setActive(true);
            this.level.scheduleUpdate(this, this, 0);
            this.level.scheduleUpdate(this, this.getSideVec(BlockFace.DOWN), 0);
            changed = true;
        }
        if (!isPowered && wasPowered) {
            this.setActive(false);
            this.level.scheduleUpdate(this, this, 0);
            this.level.scheduleUpdate(this, this.getSideVec(BlockFace.DOWN), 0);
            changed = true;
        }
        if (changed) {
            this.level.updateComparatorOutputLevel(this);
        }
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{this.toItem()};
    }
}

