/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRail;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Rail;

public class BlockRailActivator
extends BlockRail {
    public BlockRailActivator(int meta) {
        super(meta);
    }

    public BlockRailActivator() {
        this(0);
        this.canBePowered = true;
    }

    @Override
    public String getName() {
        return "Activator Rail";
    }

    @Override
    public int getId() {
        return 126;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 || type == 6 || type == 3) {
            boolean isPowered;
            if (super.onUpdate(type) == 1) {
                return 0;
            }
            boolean bl = isPowered = this.level.isBlockPowered(this) || this.checkSurrounding(this, true, 0) || this.checkSurrounding(this, false, 0);
            if (this.isActive() != isPowered) {
                this.setActive(isPowered);
                this.level.updateAround(this.getSideVec(BlockFace.DOWN));
                if (this.getOrientation().isAscending()) {
                    this.level.updateAround(this.getSideVec(BlockFace.UP));
                }
            }
            return type;
        }
        return 0;
    }

    protected boolean checkSurrounding(Vector3 pos, boolean relative, int power) {
        int dz;
        int dy;
        if (power >= 8) {
            return false;
        }
        int dx = pos.getFloorX();
        Block block2 = this.level.getBlock(dx, dy = pos.getFloorY(), dz = pos.getFloorZ());
        if (!Rail.isRailBlock(block2)) {
            return false;
        }
        BlockRail block = (BlockRail)block2;
        Rail.Orientation base = null;
        boolean onStraight = true;
        switch (block.getOrientation()) {
            case STRAIGHT_NORTH_SOUTH: {
                if (relative) {
                    ++dz;
                    break;
                }
                --dz;
                break;
            }
            case STRAIGHT_EAST_WEST: {
                if (relative) {
                    --dx;
                    break;
                }
                ++dx;
                break;
            }
            case ASCENDING_EAST: {
                if (relative) {
                    --dx;
                } else {
                    ++dx;
                    ++dy;
                    onStraight = false;
                }
                base = Rail.Orientation.STRAIGHT_EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (relative) {
                    --dx;
                    ++dy;
                    onStraight = false;
                } else {
                    ++dx;
                }
                base = Rail.Orientation.STRAIGHT_EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (relative) {
                    ++dz;
                } else {
                    --dz;
                    ++dy;
                    onStraight = false;
                }
                base = Rail.Orientation.STRAIGHT_NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (relative) {
                    ++dz;
                    ++dy;
                    onStraight = false;
                } else {
                    --dz;
                }
                base = Rail.Orientation.STRAIGHT_NORTH_SOUTH;
                break;
            }
            default: {
                return false;
            }
        }
        return this.canPowered(dx, dy, dz, base, power, relative) || onStraight && this.canPowered(dx, dy - 1, dz, base, power, relative);
    }

    protected boolean canPowered(int x, int y, int z, Rail.Orientation state, int power, boolean relative) {
        Block block = this.level.getBlock(x, y, z);
        if (!(block instanceof BlockRailActivator)) {
            return false;
        }
        Rail.Orientation base = ((BlockRailActivator)block).getOrientation();
        return (state != Rail.Orientation.STRAIGHT_EAST_WEST || base != Rail.Orientation.STRAIGHT_NORTH_SOUTH && base != Rail.Orientation.ASCENDING_NORTH && base != Rail.Orientation.ASCENDING_SOUTH) && (state != Rail.Orientation.STRAIGHT_NORTH_SOUTH || base != Rail.Orientation.STRAIGHT_EAST_WEST && base != Rail.Orientation.ASCENDING_EAST && base != Rail.Orientation.ASCENDING_WEST) && (this.level.isBlockPowered(block) || this.checkSurrounding(block, relative, power + 1));
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{this.toItem()};
    }

    @Override
    public double getHardness() {
        return 0.5;
    }
}

