/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockRailActivator;
import cn.nukkit.block.BlockRailDetector;
import cn.nukkit.block.BlockRailPowered;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.Rail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BlockRail
extends BlockFlowable
implements Faceable {
    protected boolean canBePowered = false;

    public BlockRail() {
        this(0);
    }

    public BlockRail(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Rail";
    }

    @Override
    public int getId() {
        return 66;
    }

    @Override
    public double getHardness() {
        return 0.7;
    }

    @Override
    public double getResistance() {
        return 3.5;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Optional<BlockFace> ascendingDirection = this.getOrientation().ascendingDirection();
            if (!BlockRail.canStayOnFullSolid(this.down()) || ascendingDirection.isPresent() && this.getSide(ascendingDirection.get()).isTransparent()) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 6) {
            if (this instanceof BlockRailPowered || this instanceof BlockRailDetector || this instanceof BlockRailActivator) {
                return 0;
            }
            boolean power = this.level.isBlockPowered(this);
            Map<BlockRail, BlockFace> railsAround = this.checkRailsAround(Arrays.asList(BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH));
            int railsAmount = railsAround.size();
            if (railsAmount <= 2) {
                return 0;
            }
            ArrayList<BlockRail> rails = new ArrayList<BlockRail>(railsAround.keySet());
            ArrayList<BlockFace> faces = new ArrayList<BlockFace>(railsAround.values());
            if (railsAmount == 4) {
                if (this.isAbstract()) {
                    if (power) {
                        this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)BlockFace.NORTH)), BlockFace.NORTH, (BlockRail)rails.get(faces.indexOf((Object)BlockFace.WEST)), BlockFace.WEST).metadata());
                    } else {
                        this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)BlockFace.SOUTH)), BlockFace.SOUTH, (BlockRail)rails.get(faces.indexOf((Object)BlockFace.EAST)), BlockFace.EAST).metadata());
                    }
                } else {
                    this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)BlockFace.EAST)), BlockFace.EAST, (BlockRail)rails.get(faces.indexOf((Object)BlockFace.WEST)), BlockFace.WEST).metadata());
                }
            } else if (!railsAround.isEmpty()) {
                if (this.isAbstract()) {
                    List<BlockFace> cd2 = power ? Stream.of(Rail.Orientation.CURVED_NORTH_WEST, Rail.Orientation.CURVED_SOUTH_WEST, Rail.Orientation.CURVED_NORTH_EAST).filter(o -> faces.containsAll(o.connectingDirections())).findFirst().get().connectingDirections() : Stream.of(Rail.Orientation.CURVED_SOUTH_EAST, Rail.Orientation.CURVED_NORTH_EAST, Rail.Orientation.CURVED_SOUTH_WEST).filter(o -> faces.containsAll(o.connectingDirections())).findFirst().get().connectingDirections();
                    BlockFace f12 = cd2.get(0);
                    BlockFace f22 = cd2.get(1);
                    this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)f12)), f12, (BlockRail)rails.get(faces.indexOf((Object)f22)), f22).metadata());
                } else {
                    BlockFace face = (BlockFace)((Object)faces.stream().min((f1, f2) -> f1.getIndex() < f2.getIndex() ? 1 : (this.x == this.y ? 0 : -1)).get());
                    BlockFace opposite = face.getOpposite();
                    if (faces.contains((Object)opposite)) {
                        this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)face)), face, (BlockRail)rails.get(faces.indexOf((Object)opposite)), opposite).metadata());
                    } else {
                        this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)face)), face).metadata());
                    }
                }
            }
            this.level.setBlock(this, this, true, true);
            if (!this.isAbstract()) {
                this.level.scheduleUpdate(this, this, 0);
            }
        }
        return 0;
    }

    @Override
    public AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.125;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!BlockRail.canStayOnFullSolid(this.down())) {
            return false;
        }
        Map<BlockRail, BlockFace> railsAround = this.checkRailsAroundAffected();
        ArrayList<BlockRail> rails = new ArrayList<BlockRail>(railsAround.keySet());
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>(railsAround.values());
        if (railsAround.size() == 1) {
            BlockRail other = (BlockRail)rails.get(0);
            this.setDamage(this.connect(other, railsAround.get(other)).metadata());
        } else if (railsAround.size() == 4) {
            if (this.isAbstract()) {
                this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)BlockFace.SOUTH)), BlockFace.SOUTH, (BlockRail)rails.get(faces.indexOf((Object)BlockFace.EAST)), BlockFace.EAST).metadata());
            } else {
                this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)BlockFace.EAST)), BlockFace.EAST, (BlockRail)rails.get(faces.indexOf((Object)BlockFace.WEST)), BlockFace.WEST).metadata());
            }
        } else if (!railsAround.isEmpty()) {
            if (this.isAbstract()) {
                if (railsAround.size() == 2) {
                    BlockRail rail1 = (BlockRail)rails.get(0);
                    BlockRail rail2 = (BlockRail)rails.get(1);
                    this.setDamage(this.connect(rail1, railsAround.get(rail1), rail2, railsAround.get(rail2)).metadata());
                } else {
                    List<BlockFace> cd2 = Stream.of(Rail.Orientation.CURVED_SOUTH_EAST, Rail.Orientation.CURVED_NORTH_EAST, Rail.Orientation.CURVED_SOUTH_WEST).filter(o -> faces.containsAll(o.connectingDirections())).findFirst().get().connectingDirections();
                    BlockFace f12 = cd2.get(0);
                    BlockFace f22 = cd2.get(1);
                    this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)f12)), f12, (BlockRail)rails.get(faces.indexOf((Object)f22)), f22).metadata());
                }
            } else {
                BlockFace f = (BlockFace)((Object)faces.stream().min((f1, f2) -> f1.getIndex() < f2.getIndex() ? 1 : (this.x == this.y ? 0 : -1)).get());
                BlockFace fo = f.getOpposite();
                if (faces.contains((Object)fo)) {
                    this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)f)), f, (BlockRail)rails.get(faces.indexOf((Object)fo)), fo).metadata());
                } else {
                    this.setDamage(this.connect((BlockRail)rails.get(faces.indexOf((Object)f)), f).metadata());
                }
            }
        }
        this.getLevel().setBlock(this, this, true, true);
        if (!this.isAbstract()) {
            this.level.scheduleUpdate(this, this, 0);
        }
        return true;
    }

    private Rail.Orientation connect(BlockRail rail1, BlockFace face1, BlockRail rail2, BlockFace face2) {
        this.connect(rail1, face1);
        this.connect(rail2, face2);
        if (face1.getOpposite() == face2) {
            int delta1 = (int)(this.y - rail1.y);
            int delta2 = (int)(this.y - rail2.y);
            if (delta1 == -1) {
                return Rail.Orientation.ascending(face1);
            }
            if (delta2 == -1) {
                return Rail.Orientation.ascending(face2);
            }
        }
        return Rail.Orientation.straightOrCurved(face1, face2);
    }

    private Rail.Orientation connect(BlockRail other, BlockFace face) {
        int delta = (int)(this.y - other.y);
        Map<BlockRail, BlockFace> rails = other.checkRailsConnected();
        if (rails.isEmpty()) {
            other.setOrientation(delta == 1 ? Rail.Orientation.ascending(face.getOpposite()) : Rail.Orientation.straight(face));
            return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
        }
        if (rails.size() == 1) {
            BlockFace faceConnected = rails.values().iterator().next();
            if (other.isAbstract() && faceConnected != face) {
                other.setOrientation(Rail.Orientation.curved(face.getOpposite(), faceConnected));
                return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
            }
            if (faceConnected == face) {
                if (!other.getOrientation().isAscending()) {
                    other.setOrientation(delta == 1 ? Rail.Orientation.ascending(face.getOpposite()) : Rail.Orientation.straight(face));
                }
                return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
            }
            if (other.getOrientation().hasConnectingDirections(BlockFace.NORTH, BlockFace.SOUTH)) {
                other.setOrientation(delta == 1 ? Rail.Orientation.ascending(face.getOpposite()) : Rail.Orientation.straight(face));
                return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
            }
        }
        return Rail.Orientation.STRAIGHT_NORTH_SOUTH;
    }

    private Map<BlockRail, BlockFace> checkRailsAroundAffected() {
        Map<BlockRail, BlockFace> railsAround = this.checkRailsAround(Arrays.asList(BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH));
        return railsAround.keySet().stream().filter(r -> r.checkRailsConnected().size() != 2).collect(Collectors.toMap(r -> r, railsAround::get));
    }

    private Map<BlockRail, BlockFace> checkRailsAround(Collection<BlockFace> faces) {
        HashMap<BlockRail, BlockFace> result = new HashMap<BlockRail, BlockFace>();
        faces.forEach((? super T f) -> {
            Block b = this.getSide((BlockFace)((Object)f));
            Stream.of(b, b.up(), b.down()).filter(Rail::isRailBlock).forEach((? super T block) -> result.put((BlockRail)block, (BlockFace)((Object)f)));
        });
        return result;
    }

    protected Map<BlockRail, BlockFace> checkRailsConnected() {
        Map<BlockRail, BlockFace> railsAround = this.checkRailsAround(this.getOrientation().connectingDirections());
        return railsAround.keySet().stream().filter(r -> r.getOrientation().hasConnectingDirections(((BlockFace)((Object)((Object)railsAround.get(r)))).getOpposite())).collect(Collectors.toMap(r -> r, railsAround::get));
    }

    public boolean isAbstract() {
        return this.getId() == 66;
    }

    public boolean canPowered() {
        return this.canBePowered;
    }

    public Rail.Orientation getOrientation() {
        return Rail.Orientation.byMetadata(this.getRealMeta());
    }

    public void setOrientation(Rail.Orientation o) {
        if (o.metadata() != this.getRealMeta()) {
            this.setDamage(o.metadata());
            this.level.setBlock(this, this, false, true);
        }
    }

    public int getRealMeta() {
        if (!this.isAbstract()) {
            return this.getDamage() & 7;
        }
        return this.getDamage();
    }

    public boolean isActive() {
        return (this.getDamage() & 8) != 0;
    }

    public void setActive(boolean active) {
        if (active) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() & 7);
        }
        this.level.setBlock(this, this, true, true);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.get(66)};
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }
}

