/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Event;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.entity.EntityInteractEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;

public abstract class BlockPressurePlateBase
extends BlockFlowable {
    protected float onPitch;
    protected float offPitch;

    protected BlockPressurePlateBase() {
        this(0);
    }

    protected BlockPressurePlateBase(int meta) {
        super(meta);
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public double getMinX() {
        return this.x + 0.625;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.625;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.9375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.9375;
    }

    @Override
    public double getMaxY() {
        return this.isActivated() ? this.y + 0.03125 : this.y + 0.0625;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    public boolean isActivated() {
        return this.getDamage() == 0;
    }

    @Override
    public int onUpdate(int type) {
        int power;
        if (type == 1) {
            if (!BlockPressurePlateBase.isSupportValid(this.down())) {
                this.level.useBreakOn(this, Item.get(270));
            }
        } else if (type == 3 && (power = this.getRedstonePower()) > 0) {
            this.updateState(power);
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!BlockPressurePlateBase.isSupportValid(this.down())) {
            return false;
        }
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    private static boolean isSupportValid(Block block) {
        return !block.isTransparent() || block.isNarrowSurface() || Block.canStayOnFullSolid(block);
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return new SimpleAxisAlignedBB(this.x + 0.125, this.y, this.z + 0.125, this.x + 0.875, this.y + 0.25, this.z + 0.875);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        int power = this.getRedstonePower();
        if (power == 0) {
            Event ev = entity instanceof Player ? new PlayerInteractEvent((Player)entity, null, this, null, PlayerInteractEvent.Action.PHYSICAL) : new EntityInteractEvent(entity, this);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.updateState(power);
            }
        }
    }

    protected void updateState(int oldStrength) {
        boolean isPowered;
        int strength = this.computeRedstoneStrength();
        boolean wasPowered = oldStrength > 0;
        boolean bl = isPowered = strength > 0;
        if (oldStrength != strength) {
            this.setRedstonePower(strength);
            this.level.setBlock(this, this, false, false);
            this.level.updateAroundRedstone(this, null);
            this.level.updateAroundRedstone(this.getSideVec(BlockFace.DOWN), null);
            if (!isPowered && wasPowered) {
                this.playOffSound();
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
            } else if (isPowered && !wasPowered) {
                this.playOnSound();
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
            }
        }
        if (isPowered) {
            this.level.scheduleUpdate(this, 20);
        }
    }

    @Override
    public boolean onBreak(Item item) {
        this.level.setBlock(this, Block.get(0), true, true);
        if (this.getRedstonePower() > 0) {
            this.level.updateAroundRedstone(this, null);
            this.level.updateAroundRedstone(this.getSideVec(BlockFace.DOWN), null);
        }
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.getRedstonePower();
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return side == BlockFace.UP ? this.getRedstonePower() : 0;
    }

    public int getRedstonePower() {
        return this.getDamage();
    }

    public void setRedstonePower(int power) {
        this.setDamage(power);
    }

    protected void playOnSound() {
        this.level.addLevelSoundEvent(this, 73);
    }

    protected void playOffSound() {
        this.level.addLevelSoundEvent(this, 74);
    }

    protected abstract int computeRedstoneStrength();

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

