/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEndPortal;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockNetherPortal;
import cn.nukkit.block.BlockPistonHead;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityPistonArm;
import cn.nukkit.event.block.BlockPistonChangeEvent;
import cn.nukkit.event.block.BlockPistonEvent;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Faceable;
import java.util.ArrayList;
import java.util.List;

public abstract class BlockPistonBase
extends BlockSolidMeta
implements Faceable {
    public boolean sticky;

    public BlockPistonBase() {
        this(0);
    }

    public BlockPistonBase(int meta) {
        super(meta);
    }

    public abstract int getPistonHeadBlockId();

    @Override
    public double getResistance() {
        return 1.5;
    }

    @Override
    public double getHardness() {
        return 1.5;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (Math.abs((double)player.getFloorX() - this.x) < 2.0 && Math.abs((double)player.getFloorZ() - this.z) < 2.0) {
            double y = player.y + (double)player.getEyeHeight();
            if (y - this.y > 2.0) {
                this.setDamage(BlockFace.UP.getIndex());
            } else if (this.y - y > 0.0) {
                this.setDamage(BlockFace.DOWN.getIndex());
            } else {
                this.setDamage(player.getHorizontalFacing().getIndex());
            }
        } else {
            this.setDamage(player.getHorizontalFacing().getIndex());
        }
        this.getLevel().setBlock(this, this, true, false);
        CompoundTag nbt = new CompoundTag("").putString("id", "PistonArm").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putBoolean("Sticky", this.sticky);
        BlockEntityPistonArm be = (BlockEntityPistonArm)BlockEntity.createBlockEntity("PistonArm", this.getChunk(), nbt, new Object[0]);
        be.sticky = this.sticky;
        be.spawnToAll();
        this.checkState();
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        this.level.setBlock(this, Block.get(0), true, true);
        Block block = this.getSide(this.getFacing());
        if (block instanceof BlockPistonHead && ((BlockPistonHead)block).getBlockFace() == this.getFacing()) {
            block.onBreak(item);
        }
        return true;
    }

    public boolean isExtended() {
        BlockFace face = this.getFacing();
        Block block = this.getSide(face);
        return block instanceof BlockPistonHead && ((BlockPistonHead)block).getBlockFace() == face;
    }

    @Override
    public int onUpdate(int type) {
        if (type != 6 && type != 1) {
            return 0;
        }
        if (type == 6) {
            RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
            this.getLevel().getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return 0;
            }
        }
        this.checkState();
        return type;
    }

    private void checkState() {
        BlockFace facing = this.getFacing();
        boolean isPowered = this.isPowered();
        boolean extended = this.isExtended();
        if (isPowered && !extended) {
            BlocksCalculator calculator = new BlocksCalculator(this, facing, true);
            if (calculator.canMove()) {
                if (!this.doMove(true, calculator)) {
                    return;
                }
                this.updateBlockEntity(true);
                this.getLevel().addLevelSoundEvent(this, 84);
            }
            return;
        }
        if (!isPowered && extended) {
            if (this.sticky) {
                Position pos = this.add(facing.getXOffset() << 1, facing.getYOffset() << 1, facing.getZOffset() << 1);
                Block block = this.level.getBlock(pos);
                if (block.getId() == 0) {
                    this.level.setBlock(this.getSideVec(facing), Block.get(0), true, true);
                }
                if (BlockPistonBase.canPush(block, facing.getOpposite(), false) && (!(block instanceof BlockFlowable) && !block.breakWhenPushed() || block.getId() == 33 || block.getId() == 29) && this.doMove(false, null)) {
                    this.updateBlockEntity(false);
                }
            } else {
                this.updateBlockEntity(false);
                this.level.setBlock(this.getSideVec(facing), Block.get(0), true, true);
            }
            this.getLevel().addLevelSoundEvent(this, 83);
        }
    }

    public BlockFace getFacing() {
        BlockFace face = BlockFace.fromIndex(this.getDamage()).getOpposite();
        if (face == BlockFace.UP) {
            return BlockFace.DOWN;
        }
        if (face == BlockFace.DOWN) {
            return BlockFace.UP;
        }
        return face;
    }

    private boolean isPowered() {
        BlockFace face = this.getFacing();
        if (face == BlockFace.UP) {
            face = BlockFace.DOWN;
        }
        if (face == BlockFace.DOWN) {
            face = BlockFace.UP;
        }
        for (BlockFace side : BlockFace.values()) {
            if (side == face || !this.level.isSidePowered(this.getSideVec(side), side)) continue;
            return true;
        }
        if (this.level.isSidePowered(this, BlockFace.DOWN)) {
            return true;
        }
        Vector3 pos = this.getSideVec(BlockFace.UP);
        for (BlockFace side : BlockFace.values()) {
            if (side == BlockFace.DOWN || !this.level.isSidePowered(pos.getSideVec(side), side)) continue;
            return true;
        }
        return false;
    }

    private void updateBlockEntity(boolean extending) {
        BlockEntityPistonArm arm;
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityPistonArm && (arm = (BlockEntityPistonArm)blockEntity).isExtended() != extending) {
            this.level.getServer().getPluginManager().callEvent(new BlockPistonChangeEvent(this, extending ? 0 : 15, extending ? 15 : 0));
            arm.setExtended(extending);
            arm.broadcastMove();
            if (arm.chunk != null) {
                arm.chunk.setChanged();
            }
        }
    }

    private boolean doMove(boolean extending, BlocksCalculator calculator) {
        BlockFace direction = this.getFacing();
        if (!extending) {
            this.level.setBlock(this.getSideVec(direction), Block.get(0), true, false);
        }
        if (calculator == null) {
            calculator = new BlocksCalculator(this, direction, extending);
        }
        if (calculator.canMove()) {
            Block block;
            int i;
            BlockPistonEvent event = new BlockPistonEvent(this, direction, calculator.getBlocksToMove(), calculator.getBlocksToDestroy(), extending);
            this.level.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return false;
            }
            List<Block> blocks = calculator.getBlocksToMove();
            if (!extending && blocks.isEmpty()) {
                this.level.setBlock(this.getSideVec(direction), Block.get(0), false, true);
                return true;
            }
            Block pistonHead = null;
            if (extending && !(pistonHead = this.getSide(direction)).canBePushed()) {
                return false;
            }
            ArrayList<Block> newBlocks = new ArrayList<Block>(blocks);
            List<Block> destroyBlocks = calculator.getBlocksToDestroy();
            BlockFace side = extending ? direction : direction.getOpposite();
            for (i = destroyBlocks.size() - 1; i >= 0; --i) {
                block = destroyBlocks.get(i);
                this.level.useBreakOn(block);
            }
            for (i = blocks.size() - 1; i >= 0; --i) {
                block = blocks.get(i);
                this.level.setBlock(block, Block.get(0), true, false);
                Vector3 newPos = block.getSideVec(side);
                this.level.setBlock(newPos, (Block)newBlocks.get(i), true, false);
            }
            if (pistonHead != null) {
                this.level.setBlock(pistonHead, Block.get(this.getPistonHeadBlockId(), this.getDamage()), true, false);
            }
            return true;
        }
        return false;
    }

    public static boolean canPush(Block block, BlockFace face, boolean destroyBlocks) {
        if (block.canBePushed() && block.getY() >= (double)block.getLevel().getMinBlockY() && (face != BlockFace.DOWN || block.getY() != (double)block.getLevel().getMinBlockY()) && block.getY() <= (double)block.getLevel().getMaxBlockY() && (face != BlockFace.UP || block.getY() != (double)block.getLevel().getMaxBlockY())) {
            if (!(block instanceof BlockPistonBase)) {
                if (block instanceof BlockFlowable && !(block instanceof BlockEndPortal) && !(block instanceof BlockNetherPortal) || block.breakWhenPushed()) {
                    return destroyBlocks;
                }
            } else {
                return !((BlockPistonBase)block).isExtended();
            }
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    public static class BlocksCalculator {
        private final Vector3 pistonPos;
        private final Block blockToMove;
        private final BlockFace moveDirection;
        private final List<Block> toMove = new ArrayList<Block>();
        private final List<Block> toDestroy = new ArrayList<Block>();
        protected Boolean canMove;

        public BlocksCalculator(Block pos, BlockFace facing, boolean extending) {
            this.pistonPos = pos.getLocation();
            if (extending) {
                this.moveDirection = facing;
                this.blockToMove = pos.getSide(facing);
            } else {
                this.moveDirection = facing.getOpposite();
                this.blockToMove = pos.getSide(facing, 2);
            }
        }

        public boolean canMove() {
            return this.canMove == null ? (this.canMove = Boolean.valueOf(this.eval())) : this.canMove;
        }

        private boolean eval() {
            this.toMove.clear();
            this.toDestroy.clear();
            if (!BlockPistonBase.canPush(this.blockToMove, this.moveDirection, false)) {
                if (this.blockToMove instanceof BlockFlowable && !(this.blockToMove instanceof BlockEndPortal) && !(this.blockToMove instanceof BlockNetherPortal) || this.blockToMove.breakWhenPushed()) {
                    boolean exists = false;
                    for (Block b : this.toDestroy) {
                        if (b.x != this.blockToMove.x || b.y != this.blockToMove.y || b.z != this.blockToMove.z) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        this.toDestroy.add(this.blockToMove);
                    }
                    return true;
                }
                return false;
            }
            return this.addBlockLine(this.blockToMove);
        }

        private boolean addBlockLine(Block origin) {
            Block block = origin;
            if (block.getId() == 0) {
                return true;
            }
            if (!BlockPistonBase.canPush(origin, this.moveDirection, false)) {
                return true;
            }
            if (origin.equals(this.pistonPos)) {
                return true;
            }
            if (this.toMove.contains(origin)) {
                return true;
            }
            int count = 1;
            if (count + this.toMove.size() > 12) {
                return false;
            }
            int blockCount = 0;
            for (int step = count - 1; step >= 0; --step) {
                Block aBlock = block.getSide(this.moveDirection.getOpposite(), step);
                if (aBlock.breakWhenPushed()) {
                    return true;
                }
                this.toMove.add(aBlock);
                ++blockCount;
            }
            int steps = 1;
            while (true) {
                Block nextBlock;
                int index;
                if ((index = this.toMove.indexOf(nextBlock = block.getSide(this.moveDirection, steps))) > -1) {
                    this.reorderListAtCollision(blockCount, index);
                    for (int l = 0; l <= index + blockCount; ++l) {
                        Block block2 = this.toMove.get(l);
                    }
                    return true;
                }
                if (nextBlock.getId() == 0) {
                    return true;
                }
                if (!BlockPistonBase.canPush(nextBlock, this.moveDirection, true) || nextBlock.equals(this.pistonPos)) {
                    return false;
                }
                if (nextBlock instanceof BlockFlowable && !(nextBlock instanceof BlockEndPortal) && !(nextBlock instanceof BlockNetherPortal) || nextBlock.breakWhenPushed()) {
                    boolean exists = false;
                    for (Block b : this.toDestroy) {
                        if (b.x != nextBlock.x || b.y != nextBlock.y || b.z != nextBlock.z) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        this.toDestroy.add(nextBlock);
                    }
                    return true;
                }
                if (this.toMove.size() >= 12) {
                    return false;
                }
                this.toMove.add(nextBlock);
                ++blockCount;
                ++steps;
            }
        }

        private void reorderListAtCollision(int count, int index) {
            ArrayList<Block> list = new ArrayList<Block>(this.toMove.subList(0, index));
            ArrayList<Block> list1 = new ArrayList<Block>(this.toMove.subList(this.toMove.size() - count, this.toMove.size()));
            ArrayList<Block> list2 = new ArrayList<Block>(this.toMove.subList(index, this.toMove.size() - count));
            this.toMove.clear();
            this.toMove.addAll(list);
            this.toMove.addAll(list1);
            this.toMove.addAll(list2);
        }

        public List<Block> getBlocksToMove() {
            return this.toMove;
        }

        public List<Block> getBlocksToDestroy() {
            return this.toDestroy;
        }
    }
}

