/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockSolid;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockOreGoldNether
extends BlockSolid {
    @Override
    public int getId() {
        return 543;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return "Nether Gold Ore";
    }

    @Override
    public Item[] getDrops(Item item) {
        if (!item.isPickaxe()) {
            return new Item[0];
        }
        Enchantment enchantment = item.getEnchantment(18);
        int fortune = 0;
        if (enchantment != null) {
            fortune = enchantment.getLevel();
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int count = random.nextInt(2, 7);
        switch (fortune) {
            case 0: {
                break;
            }
            case 1: {
                if (random.nextInt(0, 2) != 0) break;
                count *= 2;
                break;
            }
            case 2: {
                if (random.nextInt(0, 1) != 0) break;
                count *= random.nextInt(2, 3);
                break;
            }
            default: {
                if (random.nextInt(0, 4) >= 3) break;
                count *= random.nextInt(2, 4);
            }
        }
        return new Item[]{Item.get(371, (Integer)0, count)};
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }
}

