/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockSolid;
import cn.nukkit.item.Item;
import cn.nukkit.math.NukkitMath;
import java.util.concurrent.ThreadLocalRandom;

public abstract class BlockOre
extends BlockSolid {
    @Override
    public Item[] getDrops(Item item) {
        int fortuneLevel;
        if (!this.canHarvest(item) || item.getTier() < this.getToolTier()) {
            return new Item[0];
        }
        if (item.hasEnchantment(16)) {
            return new Item[]{this.toItem()};
        }
        int rawMaterial = this.getRawMaterial();
        if (rawMaterial == 0) {
            return super.getDrops(item);
        }
        float multiplier = this.getDropMultiplier();
        int amount = (int)multiplier;
        if (amount > 1) {
            amount = 1 + ThreadLocalRandom.current().nextInt(amount);
        }
        if ((fortuneLevel = NukkitMath.clamp(item.getEnchantmentLevel(18), 0, 3)) > 0) {
            int increase = ThreadLocalRandom.current().nextInt((int)(multiplier * (float)fortuneLevel) + 1);
            amount += increase;
        }
        return new Item[]{Item.get(rawMaterial, (Integer)this.getRawMaterialMeta(), amount)};
    }

    protected abstract int getRawMaterial();

    protected int getRawMaterialMeta() {
        return 0;
    }

    protected float getDropMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getToolTier() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }
}

