/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;

public class BlockObserver
extends BlockSolidMeta
implements Faceable {
    private Vector3 updatePos;

    public BlockObserver() {
        this(0);
    }

    public BlockObserver(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 251;
    }

    @Override
    public String getName() {
        return "Observer";
    }

    @Override
    public double getHardness() {
        return 3.5;
    }

    @Override
    public double getResistance() {
        return 17.5;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe()) {
            return new Item[]{Item.get(251, (Integer)0, 1)};
        }
        return new Item[0];
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (player != null) {
            if (Math.abs(player.x - this.x) < 2.0 && Math.abs(player.z - this.z) < 2.0) {
                double y = player.y + (double)player.getEyeHeight();
                if (y - this.y > 2.0) {
                    this.setDamage(BlockFace.DOWN.getIndex());
                } else if (this.y - y > 0.0) {
                    this.setDamage(BlockFace.UP.getIndex());
                } else {
                    this.setDamage(player.getHorizontalFacing().getIndex());
                }
            } else {
                this.setDamage(player.getHorizontalFacing().getIndex());
            }
        }
        return this.getLevel().setBlock(this, this, true, true);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.getSideVec(this.getBlockFace()).equals(this.updatePos) && !this.isPowered()) {
            RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return 0;
            }
            this.setPowered(true);
            this.level.setBlock(this, this, false, false);
            this.level.updateAroundRedstone(this, this.getBlockFace());
            this.level.scheduleUpdate(this, 4);
            return 1;
        }
        if (type == 3 && this.isPowered()) {
            RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return 0;
            }
            this.setPowered(false);
            this.level.setBlock(this, this, false, false);
            this.level.updateAroundRedstone(this, this.getBlockFace());
        }
        return type;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(251));
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return this.isPowered() && side == this.getBlockFace() ? 15 : 0;
    }

    @Override
    public int getWeakPower(BlockFace face) {
        return this.getStrongPower(face);
    }

    public boolean isPowered() {
        return (this.getDamage() & 8) == 8;
    }

    public void setPowered(boolean powered) {
        this.setDamage(this.getDamage() & 7 | (powered ? 8 : 0));
    }

    @Override
    public Block setUpdatePos(Vector3 pos) {
        this.updatePos = pos;
        return this;
    }
}

