/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.level.NetherPortalSpawnEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockNetherPortal
extends BlockFlowable
implements Faceable {
    public BlockNetherPortal() {
        this(0);
    }

    public BlockNetherPortal(int meta) {
        super(0);
    }

    @Override
    public String getName() {
        return "Nether Portal Block";
    }

    @Override
    public int getId() {
        return 90;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public double getHardness() {
        return -1.0;
    }

    @Override
    public int getLightLevel() {
        return 11;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(0));
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        boolean result = super.onBreak(item);
        for (BlockFace face : BlockFace.values()) {
            Block b = this.getSide(face);
            if (!(b instanceof BlockNetherPortal)) continue;
            result &= b.onBreak(item);
        }
        return result;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    public static boolean trySpawnPortal(Level level, Vector3 pos) {
        return BlockNetherPortal.trySpawnPortal(level, pos, false);
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    public static boolean trySpawnPortal(Level level, Vector3 pos, boolean force) {
        PortalBuilder builder = new PortalBuilder(level, pos, BlockFace.Axis.X, force);
        if (builder.isValid() && builder.portalBlockCount == 0) {
            builder.placePortalBlocks();
            return true;
        }
        builder = new PortalBuilder(level, pos, BlockFace.Axis.Z, force);
        if (builder.isValid() && builder.portalBlockCount == 0) {
            builder.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static Position getSafePortal(Position portal) {
        Level level = portal.getLevel();
        FullChunk chunk = portal.getChunk();
        Vector3 down = portal.getSideVec(BlockFace.DOWN);
        while (level.getBlockIdAt(chunk, down.getFloorX(), down.getFloorY(), down.getFloorZ()) == 90) {
            down = down.getSideVec(BlockFace.DOWN);
        }
        return Position.fromObject(down.up(), portal.getLevel());
    }

    public static Position findNearestPortal(Position pos) {
        int z;
        int y;
        Level level = pos.getLevel();
        Vector3 found = null;
        int maxY = level.getMaxBlockY();
        for (int xx = -16; xx <= 16; ++xx) {
            block1: for (int zz = -16; zz <= 16; ++zz) {
                for (y = 0; y < maxY; ++y) {
                    int z2;
                    int x = pos.getFloorX() + xx;
                    if (level.getBlockIdAt(x, y, z2 = pos.getFloorZ() + zz) != 90) continue;
                    found = new Position(x, y, z2, level);
                    continue block1;
                }
            }
        }
        if (found == null) {
            return null;
        }
        Vector3 up = found.up();
        int x = up.getFloorX();
        int id = level.getBlockIdAt(x, y = up.getFloorY(), z = up.getFloorZ());
        if (id != 0 && id != 49 && id != 90) {
            for (int xx = -1; xx < 4; ++xx) {
                for (int yy = 1; yy < 4; ++yy) {
                    for (int zz = -1; zz < 3; ++zz) {
                        level.setBlockAt(x + xx, y + yy, z + zz, 0);
                    }
                }
            }
        }
        return found;
    }

    public static void spawnPortal(Position pos) {
        NetherPortalSpawnEvent ev = new NetherPortalSpawnEvent(pos);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        Level lvl = pos.level;
        int x = pos.getFloorX();
        int y = pos.getFloorY();
        int z = pos.getFloorZ();
        for (int xx = -1; xx < 4; ++xx) {
            for (int yy = 1; yy < 4; ++yy) {
                for (int zz = -1; zz < 3; ++zz) {
                    lvl.setBlockAt(x + xx, y + yy, z + zz, 0);
                }
            }
        }
        lvl.setBlockAt(x + 1, y, z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x, y, ++z, 49);
        lvl.setBlockAt(x + 1, y, z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x + 1, y, ++z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x, ++y, --z, 49);
        lvl.setBlockAt(x + 1, y, z, 90);
        lvl.setBlockAt(x + 2, y, z, 90);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x, ++y, z, 49);
        lvl.setBlockAt(x + 1, y, z, 90);
        lvl.setBlockAt(x + 2, y, z, 90);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x, ++y, z, 49);
        lvl.setBlockAt(x + 1, y, z, 90);
        lvl.setBlockAt(x + 2, y, z, 90);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x, ++y, z, 49);
        lvl.setBlockAt(x + 1, y, z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x + 3, y, z, 49);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    public static class PortalBuilder {
        private final Level level;
        private final BlockFace.Axis axis;
        private final BlockFace rightDir;
        private final BlockFace leftDir;
        private int portalBlockCount;
        private Vector3 bottomLeft;
        private int height;
        private int width;
        private final boolean force;

        public PortalBuilder(Level level, Vector3 pos, BlockFace.Axis axis, boolean force) {
            this.level = level;
            this.axis = axis;
            this.force = force;
            if (axis == BlockFace.Axis.X) {
                this.leftDir = BlockFace.EAST;
                this.rightDir = BlockFace.WEST;
            } else {
                this.leftDir = BlockFace.NORTH;
                this.rightDir = BlockFace.SOUTH;
            }
            Vector3 blockpos = pos;
            while (pos.getY() > blockpos.getY() - 21.0 && pos.getY() > (double)level.getMinBlockY() && this.isEmptyBlock(this.getBlockId(pos.getSideVec(BlockFace.DOWN)))) {
                pos = pos.getSideVec(BlockFace.DOWN);
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.getSideVec(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(Vector3 pos, BlockFace dir) {
            Vector3 v;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.getBlockId(v = pos.getSideVec(dir, i))) && this.getBlockId(v.getSideVec(BlockFace.DOWN)) == 49; ++i) {
            }
            return this.getBlockId(pos.getSideVec(dir, i)) == 49 ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            int i;
            this.height = 0;
            block0: while (this.height < 21) {
                for (i = 0; i < this.width; ++i) {
                    Vector3 blockpos = this.bottomLeft.getSideVec(this.rightDir, i).up(this.height);
                    int block = this.getBlockId(blockpos);
                    if (!this.isEmptyBlock(block)) break block0;
                    if (block == 90) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.getBlockId(blockpos.getSideVec(this.leftDir))) != 49 : i == this.width - 1 && (block = this.getBlockId(blockpos.getSideVec(this.rightDir))) != 49) break block0;
                }
                ++this.height;
            }
            for (i = 0; i < this.width; ++i) {
                if (this.getBlockId(this.bottomLeft.getSideVec(this.rightDir, i).up(this.height)) == 49) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        private int getBlockId(Vector3 pos) {
            return this.level.getBlockIdAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
        }

        protected boolean isEmptyBlock(int id) {
            return this.force || id == 0 || id == 51 || id == 90;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                Vector3 blockpos = this.bottomLeft.getSideVec(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.level.setBlock(blockpos.up(j), Block.get(90, this.axis == BlockFace.Axis.X ? 1 : (this.axis == BlockFace.Axis.Z ? 2 : 0)));
                }
            }
        }
    }
}

