/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDirt;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockMoss
extends BlockDirt {
    public BlockMoss() {
    }

    public BlockMoss(int meta) {
        super(0);
    }

    @Override
    public int getId() {
        return 575;
    }

    @Override
    public String getName() {
        return "Moss Block";
    }

    @Override
    public double getHardness() {
        return 0.1;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block block;
        if (item.getId() != 351 || item.getDamage() != 15 || this.up().getId() != 0) {
            return false;
        }
        int random = ThreadLocalRandom.current().nextInt(13);
        Block block2 = null;
        if (random < 5) {
            block = Block.get(31);
        } else if (random < 8) {
            block = Block.get(590);
        } else if (random < 9) {
            if (this.up(2).getId() != 0) {
                return false;
            }
            block = Block.get(175, 2);
            block2 = Block.get(175, 10);
        } else {
            block = random < 11 ? Block.get(592) : Block.get(593);
        }
        this.getLevel().setBlock(this.up(), block, false, true);
        if (block2 != null) {
            this.getLevel().setBlock(this.up(2), block2, false, true);
        }
        this.level.addParticle(new BoneMealParticle(this));
        if (player != null && !player.isCreative()) {
            --item.count;
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GREEN_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public int getFullId() {
        return this.getId() << 6;
    }

    @Override
    public void setDamage(int meta) {
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId()), 0, 1);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.canHarvestWithHand() || this.canHarvest(item)) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public int getToolType() {
        return 6;
    }
}

