/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockFormEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.inventory.PlayerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.utils.BlockColor;

public class BlockMagma
extends BlockSolid {
    @Override
    public int getId() {
        return 213;
    }

    @Override
    public String getName() {
        return "Magma Block";
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 0.5;
    }

    @Override
    public int getLightLevel() {
        return 3;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe()) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (entity.y >= this.y + 1.0 && !entity.hasEffect(12)) {
            if (entity instanceof Player) {
                Player p = (Player)entity;
                PlayerInventory inv = p.getInventory();
                if (inv == null || inv.getBootsFast().hasEnchantment(25) || !entity.level.gameRules.getBoolean(GameRule.FIRE_DAMAGE)) {
                    return;
                }
                if (!(p.isCreative() || p.isSpectator() || p.isSneaking())) {
                    entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.MAGMA, 1.0f));
                }
            } else {
                entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.MAGMA, 1.0f));
            }
        }
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public int onUpdate(int type) {
        Block up;
        if (type == 1 && (up = this.up()) instanceof BlockWater && (up.getDamage() == 0 || up.getDamage() == 8)) {
            BlockFormEvent event = new BlockFormEvent(up, Block.get(415, 1));
            Server.getInstance().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.getLevel().setBlock(up, event.getNewState(), false, true);
            }
        }
        return 0;
    }
}

