/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockLever
extends BlockFlowable
implements Faceable {
    public BlockLever() {
        this(0);
    }

    public BlockLever(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lever";
    }

    @Override
    public int getId() {
        return 69;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{this.toItem()};
    }

    public boolean isPowerOn() {
        return (this.getDamage() & 8) > 0;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isPowerOn() ? 15 : 0, this.isPowerOn() ? 0 : 15));
        this.setDamage(this.getDamage() ^ 8);
        this.getLevel().setBlock(this, this, false, true);
        if (this.isPowerOn()) {
            this.level.addLevelSoundEvent(this, 73);
        } else {
            this.level.addLevelSoundEvent(this, 74);
        }
        LeverOrientation orientation = LeverOrientation.byMetadata(this.isPowerOn() ? this.getDamage() ^ 8 : this.getDamage());
        BlockFace face = orientation.getFacing();
        this.level.updateAroundRedstone(this, null);
        this.level.updateAroundRedstone(this.getSideVec(face.getOpposite()), this.isPowerOn() ? face : null);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        int face;
        BlockFace faces;
        if (type == 1 && !this.isSupportValid(this.getSide(faces = LeverOrientation.byMetadata(face = this.isPowerOn() ? this.getDamage() ^ 8 : this.getDamage()).getFacing().getOpposite()))) {
            this.level.useBreakOn(this);
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        LeverOrientation faces = LeverOrientation.forFacings(face, player.getHorizontalFacing());
        this.setDamage(faces.getMetadata());
        if (!this.isSupportValid(this.getSide(faces.facing.getOpposite()))) {
            return false;
        }
        return this.getLevel().setBlock(block, this, true, true);
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock(this, Block.get(0), true, true);
        if (this.isPowerOn()) {
            BlockFace face = LeverOrientation.byMetadata(this.getDamage() ^ 8).getFacing();
            this.level.updateAround(this.getSideVec(face.getOpposite()));
        }
        return true;
    }

    private boolean isSupportValid(Block block) {
        if (!block.isTransparent()) {
            return true;
        }
        if (BlockFace.fromIndex(this.isPowerOn() ? this.getDamage() ^ 8 : this.getDamage()) == BlockFace.DOWN) {
            return Block.canStayOnFullSolid(block);
        }
        return Block.canConnectToFullSolid(block);
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isPowerOn() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        if (!this.isPowerOn()) {
            return 0;
        }
        return LeverOrientation.byMetadata(this.getDamage() ^ 8).getFacing() == side ? 15 : 0;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.FLOW_INTO_BLOCK;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    public static enum LeverOrientation {
        DOWN_X(0, "down_x", BlockFace.DOWN),
        EAST(1, "east", BlockFace.EAST),
        WEST(2, "west", BlockFace.WEST),
        SOUTH(3, "south", BlockFace.SOUTH),
        NORTH(4, "north", BlockFace.NORTH),
        UP_Z(5, "up_z", BlockFace.UP),
        UP_X(6, "up_x", BlockFace.UP),
        DOWN_Z(7, "down_z", BlockFace.DOWN);

        private static final LeverOrientation[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final BlockFace facing;

        private LeverOrientation(int meta, String name, BlockFace face) {
            this.meta = meta;
            this.name = name;
            this.facing = face;
        }

        public int getMetadata() {
            return this.meta;
        }

        public BlockFace getFacing() {
            return this.facing;
        }

        public String toString() {
            return this.name;
        }

        public static LeverOrientation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static LeverOrientation forFacings(BlockFace clickedSide, BlockFace playerDirection) {
            switch (clickedSide) {
                case DOWN: {
                    switch (playerDirection.getAxis()) {
                        case X: {
                            return DOWN_X;
                        }
                        case Z: {
                            return DOWN_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + (Object)((Object)playerDirection) + " for facing " + (Object)((Object)clickedSide));
                }
                case UP: {
                    switch (playerDirection.getAxis()) {
                        case X: {
                            return UP_X;
                        }
                        case Z: {
                            return UP_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + (Object)((Object)playerDirection) + " for facing " + (Object)((Object)clickedSide));
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("Invalid facing: " + (Object)((Object)clickedSide));
        }

        public String getName() {
            return this.name;
        }

        static {
            META_LOOKUP = new LeverOrientation[LeverOrientation.values().length];
            LeverOrientation[] leverOrientationArray = LeverOrientation.values();
            int n = leverOrientationArray.length;
            for (int i = 0; i < n; ++i) {
                LeverOrientation face;
                LeverOrientation.META_LOOKUP[face.meta] = face = leverOrientationArray[i];
            }
        }
    }
}

