/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityLectern;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockLectern
extends BlockTransparentMeta
implements Faceable {
    public BlockLectern() {
        this(0);
    }

    public BlockLectern(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lectern";
    }

    @Override
    public int getId() {
        return 449;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public double getHardness() {
        return 2.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public int getBurnChance() {
        return 30;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        int horizontalIndex = (player != null ? player.getDirection().getOpposite() : BlockFace.SOUTH).getHorizontalIndex();
        if (horizontalIndex >= 0) {
            this.setDamage(this.getDamage() & 0xC | horizontalIndex & 3);
        }
        CompoundTag nbt = new CompoundTag().putString("id", "Lectern").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        BlockEntityLectern lectern = (BlockEntityLectern)BlockEntity.createBlockEntity("Lectern", this.getChunk(), nbt, new Object[0]);
        if (lectern == null) {
            return false;
        }
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    public boolean dropBook() {
        BlockEntityLectern lectern;
        Item book;
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (blockEntity instanceof BlockEntityLectern && (book = (lectern = (BlockEntityLectern)blockEntity).getBook()).getId() != 0) {
            lectern.setBook(Item.get(0));
            lectern.spawnToAll();
            this.level.dropItem(lectern.add(0.5, 1.0, 0.5), book);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    public boolean isActivated() {
        return (this.getDamage() & 4) == 4;
    }

    public void setActivated(boolean activated) {
        if (activated) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() ^ 4);
        }
    }

    @Override
    public int getWeakPower(BlockFace face) {
        return this.isActivated() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntity t2 = this.getLevel().getBlockEntity(this);
            if (!(t2 instanceof BlockEntityLectern)) {
                return false;
            }
            BlockEntityLectern lectern = (BlockEntityLectern)t2;
            Item currentBook = lectern.getBook();
            if (currentBook.getId() == 0) {
                if (item.getId() == 387 || item.getId() == 386) {
                    Item newBook = item.clone();
                    if (!player.isCreative()) {
                        --item.count;
                    }
                    newBook.setCount(1);
                    lectern.setBook(newBook);
                    lectern.spawnToAll();
                    this.level.addLevelSoundEvent(this, 256);
                }
            } else {
                ContainerOpenPacket pk = new ContainerOpenPacket();
                pk.windowId = -1;
                pk.type = InventoryType.LECTERN.getNetworkType();
                pk.x = (int)this.x;
                pk.y = (int)this.y;
                pk.z = (int)this.z;
                pk.entityId = player.getId();
                player.dataPacket(pk);
            }
        }
        return true;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

