/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.LeavesDecayEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class BlockLeaves
extends BlockTransparentMeta {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;
    private static final String[] NAMES = new String[]{"Oak Leaves", "Spruce Leaves", "Birch Leaves", "Jungle Leaves"};

    public BlockLeaves() {
        this(0);
    }

    public BlockLeaves(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public int getToolType() {
        return 6;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 3];
    }

    @Override
    public int getBurnChance() {
        return 30;
    }

    @Override
    public int getBurnAbility() {
        return 60;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPersistent(true);
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock((Block)this, this.getDamage() & 3, 1);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        if (item.hasEnchantment(16)) {
            return new Item[]{this.toItem()};
        }
        if (this.canDropApple() && Utils.random.nextInt(200) == 0) {
            return new Item[]{Item.get(260)};
        }
        if (Utils.random.nextInt(20) == 0) {
            if (Utils.rand()) {
                return new Item[]{Item.get(280, (Integer)0, Utils.random.nextInt(1, 2))};
            }
            if ((this.getDamage() & 3) != 3 || Utils.random.nextInt(20) == 0) {
                return new Item[]{this.getSapling()};
            }
        }
        return new Item[0];
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && !this.isPersistent() && !this.isCheckDecay()) {
            this.setCheckDecay(true);
            this.getLevel().setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, false, false);
            return 1;
        }
        if (type == 2 && this.isCheckDecay() && !this.isPersistent()) {
            LeavesDecayEvent ev = new LeavesDecayEvent(this);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled() || this.findLog()) {
                this.setCheckDecay(false);
                this.getLevel().setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, false, false);
            } else {
                this.getLevel().useBreakOn(this);
            }
            return 2;
        }
        return 0;
    }

    public boolean isCheckDecay() {
        return (this.getDamage() & 8) != 0;
    }

    public void setCheckDecay(boolean checkDecay) {
        if (checkDecay) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() & 0xFFFFFFF7);
        }
    }

    public boolean isPersistent() {
        return (this.getDamage() & 4) != 0;
    }

    public void setPersistent(boolean persistent) {
        if (persistent) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() & 0xFFFFFFFB);
        }
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    protected boolean canDropApple() {
        return (this.getDamage() & 3) == 0;
    }

    protected Item getSapling() {
        return Item.get(6, (Integer)(this.getDamage() & 3));
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    private boolean findLog() {
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        HashMap<Block, Integer> distance = new HashMap<Block, Integer>();
        queue.offer(this);
        visited.add(this);
        distance.put(this, 0);
        while (!queue.isEmpty()) {
            Block currentBlock = (Block)queue.poll();
            int currentDistance = (Integer)distance.get(currentBlock);
            if (currentDistance > 4) {
                return false;
            }
            for (BlockFace face : BlockFace.values()) {
                Block nextBlock = currentBlock.getSideIfLoadedOrNull(face);
                if (nextBlock == null || nextBlock.getId() == 17 || nextBlock.getId() == 162) {
                    return true;
                }
                if (nextBlock.getId() != 18 && nextBlock.getId() != 161 || visited.contains(nextBlock)) continue;
                queue.offer(nextBlock);
                visited.add(nextBlock);
                distance.put(nextBlock, currentDistance + 1);
            }
        }
        return false;
    }
}

