/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBlueIce;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockSoulSoil;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.BaseEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityPrimedTNT;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.event.entity.EntityCombustByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockLava
extends BlockLiquid {
    public BlockLava() {
        this(0);
    }

    public BlockLava(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public String getName() {
        return "Lava";
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.highestPosition -= (entity.highestPosition - entity.y) * 0.5;
        if (!(entity.fireProof && entity.isOnFire() && entity instanceof BaseEntity)) {
            if (!entity.fireProof || !entity.isOnFire()) {
                EntityCombustByBlockEvent ev = new EntityCombustByBlockEvent(this, entity, 8);
                Server.getInstance().getPluginManager().callEvent(ev);
                if (!ev.isCancelled() && entity.isAlive() && entity.noDamageTicks == 0) {
                    entity.setOnFire(ev.getDuration());
                }
            }
            if (!entity.hasEffect(12)) {
                entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.LAVA, 4.0f));
            }
        }
        super.onEntityCollide(entity);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean ret = this.getLevel().setBlock(this, this, true, false);
        this.getLevel().scheduleUpdate(this, this.tickRate());
        return ret;
    }

    @Override
    public int onUpdate(int type) {
        int result;
        block6: {
            result = super.onUpdate(type);
            if (type != 2 || !this.level.gameRules.getBoolean(GameRule.DO_FIRE_TICK)) break block6;
            int i = Utils.random.nextInt(3);
            if (i > 0) {
                for (int k = 0; k < i; ++k) {
                    Position v = this.add(Utils.random.nextInt(3) - 1, 1.0, Utils.random.nextInt(3) - 1);
                    Block block = this.getLevel().getBlock(v);
                    if (block.getId() == 0) {
                        if (!this.isSurroundingBlockFlammable(block)) continue;
                        BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.LAVA);
                        this.level.getServer().getPluginManager().callEvent(e);
                        if (!e.isCancelled()) {
                            Block fire = Block.get(51);
                            this.getLevel().setBlock(v, fire, true);
                            this.getLevel().scheduleUpdate(fire, fire.tickRate());
                            return 2;
                        }
                        return 0;
                    }
                    if (!block.isSolid()) continue;
                    return 2;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    Position v = this.add(Utils.random.nextInt(3) - 1, 0.0, Utils.random.nextInt(3) - 1);
                    Block block = this.getLevel().getBlock(v);
                    if (block.up().getId() != 0 || block.getBurnChance() <= 0) continue;
                    BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.LAVA);
                    this.level.getServer().getPluginManager().callEvent(e);
                    if (e.isCancelled()) continue;
                    Block fire = Block.get(51);
                    this.getLevel().setBlock(v, fire, true);
                    this.getLevel().scheduleUpdate(fire, fire.tickRate());
                }
            }
        }
        return result;
    }

    protected boolean isSurroundingBlockFlammable(Block block) {
        for (BlockFace face : BlockFace.values()) {
            if (block.getSide(face).getBurnChance() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.LAVA_BLOCK_COLOR;
    }

    @Override
    public BlockLiquid getBlock(int meta) {
        return (BlockLiquid)Block.get(10, meta);
    }

    @Override
    public int tickRate() {
        if (this.level.getDimension() == 1) {
            return 10;
        }
        return 30;
    }

    @Override
    public int getFlowDecayPerBlock() {
        if (this.level.getDimension() == 1) {
            return 1;
        }
        return 2;
    }

    @Override
    protected void checkForHarden() {
        Block colliding = null;
        for (int side = 1; side < 6; ++side) {
            Block blockSide = this.getSide(BlockFace.fromIndex(side));
            if (blockSide instanceof BlockWater || blockSide.getLevelBlock(BlockLayer.WATERLOGGED) instanceof BlockWater) {
                colliding = blockSide;
                break;
            }
            if (!(blockSide instanceof BlockBlueIce) || !(this.down() instanceof BlockSoulSoil)) continue;
            this.liquidCollide(this, Block.get(489));
            return;
        }
        if (colliding != null) {
            if (this.getDamage() == 0) {
                this.liquidCollide(colliding, Block.get(49));
            } else if (this.getDamage() <= 4) {
                this.liquidCollide(colliding, Block.get(4));
            }
        }
    }

    @Override
    protected void flowIntoBlock(Block block, int newFlowDecay) {
        if (block instanceof BlockWater) {
            ((BlockLiquid)block).liquidCollide(this, Block.get(1));
        } else {
            super.flowIntoBlock(block, newFlowDecay);
        }
    }

    @Override
    public void addVelocityToEntity(Entity entity, Vector3 vector) {
        if (!(entity instanceof EntityPrimedTNT)) {
            super.addVelocityToEntity(entity, vector);
        }
    }

    @Override
    protected boolean[] getOptimalFlowDirections() {
        int[] flowCost = new int[]{1000, 1000, 1000, 1000};
        int maxCost = 4 / this.getFlowDecayPerBlock();
        for (int j = 0; j < 4; ++j) {
            int x = (int)this.x;
            int y = (int)this.y;
            int z = (int)this.z;
            if (j == 0) {
                --x;
            } else if (j == 1) {
                ++x;
            } else {
                z = j == 2 ? --z : ++z;
            }
            Block block = this.level.getBlock(x, y, z);
            if (!this.canFlowInto(block)) {
                this.flowCostVisited.put(Level.blockHash(x, y, z, this.level.getDimensionData()), (byte)-1);
                continue;
            }
            if (this.level.getBlock(x, y - 1, z).canBeFlowedInto()) {
                this.flowCostVisited.put(Level.blockHash(x, y, z, this.level.getDimensionData()), (byte)1);
                maxCost = 0;
                flowCost[j] = 0;
                continue;
            }
            if (maxCost <= 0) continue;
            this.flowCostVisited.put(Level.blockHash(x, y, z, this.level.getDimensionData()), (byte)0);
            flowCost[j] = this.calculateFlowCost(x, y, z, 1, maxCost, j ^ 1, j ^ 1);
            maxCost = Math.min(maxCost, flowCost[j]);
        }
        this.flowCostVisited.clear();
        double minCost = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            double d = flowCost[i];
            if (!(d < minCost)) continue;
            minCost = d;
        }
        boolean[] isOptimalFlowDirection = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            isOptimalFlowDirection[i] = (double)flowCost[i] == minCost;
        }
        return isOptimalFlowDirection;
    }
}

