/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFence;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockGlass;
import cn.nukkit.block.BlockGlassPane;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTrapdoor;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockLantern
extends BlockFlowable {
    public BlockLantern() {
        this(0);
    }

    public BlockLantern(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lantern";
    }

    @Override
    public int getId() {
        return 463;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public double getResistance() {
        return 3.5;
    }

    @Override
    public double getHardness() {
        return 3.5;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(463));
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public double getMinX() {
        return this.x + 0.3125;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.3125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.6875;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.5;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.6875;
    }

    private boolean isBlockAboveValid() {
        Block support = this.up();
        switch (support.getId()) {
            case 101: 
            case 154: 
            case 541: {
                return true;
            }
        }
        if (support instanceof BlockFence || support instanceof BlockGlass || support instanceof BlockGlassPane) {
            return true;
        }
        if (support instanceof BlockTrapdoor) {
            return !((BlockTrapdoor)support).isTop() && !((BlockTrapdoor)support).isOpen();
        }
        if (support instanceof BlockSlab && (support.getDamage() & 8) == 0) {
            return true;
        }
        if (support instanceof BlockStairs && (support.getDamage() & 4) == 0) {
            return true;
        }
        return !support.isTransparent() && support.isSolid() && !support.isPowerSource();
    }

    private boolean isBlockUnderValid() {
        Block down = this.down();
        return !down.isTransparent() || down.isNarrowSurface() || Block.canStayOnFullSolid(down);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean hanging;
        boolean isUnderValid = this.isBlockUnderValid();
        boolean bl = hanging = face != BlockFace.UP && this.isBlockAboveValid() && (!isUnderValid || face == BlockFace.DOWN);
        if (!isUnderValid && !hanging) {
            return false;
        }
        if (hanging) {
            this.setDamage(1);
        } else {
            this.setDamage(0);
        }
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.getDamage() == 0) {
                if (!this.isBlockUnderValid()) {
                    this.level.useBreakOn(this, null, null, true);
                }
            } else if (!this.isBlockAboveValid()) {
                this.level.useBreakOn(this, null, null, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

