/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockLadder
extends BlockTransparentMeta
implements Faceable {
    private static final int[] FACES = new int[]{0, 1, 3, 2, 5, 4};
    private double offMinX;
    private double offMinZ;
    private double offMaxX;
    private double offMaxZ;

    public BlockLadder() {
        this(0);
    }

    public BlockLadder(int meta) {
        super(meta);
        this.calculateOffsets();
    }

    @Override
    public String getName() {
        return "Ladder";
    }

    @Override
    public int getId() {
        return 65;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public boolean canBeClimbed() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    private void calculateOffsets() {
        double f = 0.1875;
        switch (this.getDamage()) {
            case 2: {
                this.offMinX = 0.0;
                this.offMinZ = 1.0 - f;
                this.offMaxX = 1.0;
                this.offMaxZ = 1.0;
                break;
            }
            case 3: {
                this.offMinX = 0.0;
                this.offMinZ = 0.0;
                this.offMaxX = 1.0;
                this.offMaxZ = f;
                break;
            }
            case 4: {
                this.offMinX = 1.0 - f;
                this.offMinZ = 0.0;
                this.offMaxX = 1.0;
                this.offMaxZ = 1.0;
                break;
            }
            case 5: {
                this.offMinX = 0.0;
                this.offMinZ = 0.0;
                this.offMaxX = f;
                this.offMaxZ = 1.0;
                break;
            }
            default: {
                this.offMinX = 0.0;
                this.offMinZ = 1.0;
                this.offMaxX = 1.0;
                this.offMaxZ = 1.0;
            }
        }
    }

    @Override
    public double getMinX() {
        return this.x + this.offMinX;
    }

    @Override
    public double getMinZ() {
        return this.z + this.offMinZ;
    }

    @Override
    public double getMaxX() {
        return this.x + this.offMaxX;
    }

    @Override
    public double getMaxZ() {
        return this.z + this.offMaxZ;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!target.isTransparent() && face.getIndex() >= 2 && face.getIndex() <= 5) {
            this.setDamage(face.getIndex());
            this.getLevel().setBlock(this, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && !this.getSide(BlockFace.fromIndex(FACES[this.getDamage()])).isSolid()) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.get(65)};
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.resetFallDistance();
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

